/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.ring.servlet.util.ContextReplacer;

public interface LookupResult {
    public static final Error FORBIDDEN = new Error(403, "Forbidden");
    public static final Error BAD_REQUEST = new Error(400, "Malformed path");
    public static final Error NOT_FOUND = new Error(404, "Not found");
    public static final Error INTERNAL_SERVER_ERROR = new Error(500, "Internal server error");

    public void service(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public long getLastModified();

    public static class IndexResource
    extends Resource {
        private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
        private static final long LAST_MODIFIED = System.currentTimeMillis() / 1000L * 1000L;
        private final URL url;
        private final String replacePattern;
        private final String contextTag;
        private final byte[] content;

        public IndexResource(URL url, String replacePattern, String contextTag, String contextPath) throws IOException {
            this(url, LAST_MODIFIED, replacePattern, contextTag, contextPath);
        }

        public IndexResource(URL url, long lastModified, String replacePattern, String contextTag, String contextPath) throws IOException {
            super(lastModified >= 0L ? lastModified : LAST_MODIFIED, "text/html");
            this.url = url;
            this.replacePattern = replacePattern;
            this.contextTag = contextTag;
            this.content = this.loadFileAndPreprocess(contextPath).getBytes(UTF_CHARSET);
        }

        @Override
        protected int getContentLength() throws IOException {
            return this.content.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy(OutputStream out) throws IOException {
            out = new BufferedOutputStream(out, 4096);
            try {
                out.write(this.content);
            }
            finally {
                out.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadFileAndPreprocess(String contextPath) throws IOException {
            InputStream iStream = this.url.openStream();
            try {
                StringWriter writer = new StringWriter(4096);
                String indexPageContent = null;
                try {
                    IndexResource.copy(writer, new InputStreamReader(iStream, UTF_CHARSET));
                    indexPageContent = writer.toString();
                }
                finally {
                    writer.close();
                }
                if (this.replacePattern != null) {
                    indexPageContent = indexPageContent.replace(this.replacePattern, contextPath);
                }
                if (this.contextTag != null) {
                    ContextReplacer r = new ContextReplacer(this.contextTag, contextPath);
                    indexPageContent = r.replaceAll(indexPageContent);
                }
                String string = indexPageContent;
                return string;
            }
            finally {
                iStream.close();
            }
        }

        protected static void copy(Writer writer, Reader reader) throws IOException {
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
        }
    }

    public static class StaticResource
    extends Resource {
        protected final int contentLength;
        private final URL url;

        public StaticResource(URL url, long lastModified, String mimeType, int contentLength, String cacheControl) {
            super(lastModified, mimeType);
            this.contentLength = contentLength;
            this.setCacheControl(cacheControl);
            this.url = url;
        }

        public StaticResource(URL url, String mimeType, String cacheControl) {
            this(url, -1L, mimeType, -1, cacheControl);
        }

        @Override
        protected int getContentLength() throws IOException {
            return this.contentLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy(OutputStream out) throws IOException {
            InputStream is = this.url.openStream();
            try {
                StaticResource.copy(out, is);
            }
            finally {
                is.close();
            }
        }

        protected static void copy(OutputStream os, InputStream is) throws IOException {
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                os.write(buffer, 0, n);
            }
        }
    }

    public static abstract class Resource
    implements LookupResult {
        protected static final int DEFAULT_BUFFER_SIZE = 4096;
        private static final String CACHE_CONTROL_HEADER = "Cache-Control";
        protected final long lastModified;
        protected final String mimeType;
        protected String cacheControl;

        public Resource(long lastModified, String mimeType) {
            this.lastModified = lastModified;
            this.mimeType = mimeType;
        }

        public void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        private void setHeaders(HttpServletResponse resp) throws IOException {
            int len;
            resp.setStatus(200);
            resp.setContentType(this.mimeType);
            if (this.cacheControl != null) {
                resp.setHeader(CACHE_CONTROL_HEADER, this.cacheControl);
            }
            if ((len = this.getContentLength()) >= 0) {
                resp.setContentLength(len);
            }
        }

        protected abstract int getContentLength() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void respondGet(HttpServletResponse resp) throws IOException {
            ServletOutputStream os = resp.getOutputStream();
            try {
                this.copy((OutputStream)os);
            }
            finally {
                os.close();
            }
        }

        protected abstract void copy(OutputStream var1) throws IOException;

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.setHeaders(resp);
            if (!req.getMethod().equalsIgnoreCase("HEAD")) {
                this.respondGet(resp);
            }
        }
    }

    public static class Error
    implements LookupResult {
        protected final int statusCode;
        protected final String message;

        public Error(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }

        @Override
        public long getLastModified() {
            return -1L;
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(this.statusCode, this.message);
        }
    }
}

