/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.clientcert.dnq.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import jetbrains.jetpass.api.authority.module.UserCreationAuthModule;
import jetbrains.jetpass.api.ssl.Certificate;
import jetbrains.jetpass.auth.module.clientcert.dnq.rest.client.api.ClientCertificateAuthModule;
import jetbrains.jetpass.rest.dto.CertificateJSON;
import jetbrains.jetpass.rest.dto.UserCreationAuthModuleJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ClientCertificateAuthModuleJSON.class)
public class ClientCertificateAuthModuleJSON
extends UserCreationAuthModuleJSON
implements ClientCertificateAuthModule {
    private String emailRdn;
    private List<CertificateJSON> trustedIssuers;

    public ClientCertificateAuthModuleJSON() {
    }

    public ClientCertificateAuthModuleJSON(@NotNull ClientCertificateAuthModule that) {
        super((UserCreationAuthModule)that);
        this.setEmailRdn(that.getEmailRdn());
        this.setAllowedCreateNewUsers(that.isAllowedCreateNewUsers());
        if (that.getTrustedIssuers() != null) {
            ArrayList<CertificateJSON> references = new ArrayList<CertificateJSON>();
            for (Certificate certificate : that.getTrustedIssuers()) {
                CertificateJSON ref = new CertificateJSON();
                ref.setId(certificate.getId());
                references.add(ref);
            }
            this.setTrustedIssuers(references);
        }
    }

    @Override
    public String getEmailRdn() {
        return this.emailRdn;
    }

    public void setEmailRdn(String emailRdn) {
        this.emailRdn = emailRdn;
    }

    public Iterable<CertificateJSON> getTrustedIssuers() {
        return this.trustedIssuers;
    }

    public void setTrustedIssuers(@Nullable Iterable<CertificateJSON> trustedIssuers) {
        this.trustedIssuers = JsonUtils.iterableToList(trustedIssuers);
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientCertificateAuthModule)) {
            return false;
        }
        ClientCertificateAuthModule that = (ClientCertificateAuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }
}

