/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.springframework.configuration.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class MyPathMatchingResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    private static final Log logger = LogFactory.getLog(MyPathMatchingResourcePatternResolver.class);

    public MyPathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Resource[] findAllClassPathResources(String location) throws IOException {
        String path = location;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Enumeration<URL> resourceUrls = this.getClassLoader().getResources(path);
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(16);
        while (resourceUrls.hasMoreElements()) {
            URL url = resourceUrls.nextElement();
            result.add(this.convertClassLoaderURL(url));
        }
        if (path.equals("")) {
            Enumeration<URL> resourceUrls2 = this.getClassLoader().getResources("META-INF");
            while (resourceUrls2.hasMoreElements()) {
                URL url = resourceUrls2.nextElement();
                String s = url.toString();
                s = s.substring(0, s.indexOf("META-INF"));
                result.add(new UrlResource(new URL(s)));
            }
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected void doRetrieveMatchingFiles(String fullPattern, File dir, Set result) throws IOException {
        File[] dirContents;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]"));
        }
        if ((dirContents = dir.listFiles()) == null) {
            logger.warn((Object)("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]"));
            return;
        }
        for (int i = 0; i < dirContents.length; ++i) {
            File content = dirContents[i];
            String currPath = StringUtils.replace((String)content.getAbsolutePath(), (String)File.separator, (String)"/");
            if (content.isDirectory() && this.getPathMatcher().matchStart(fullPattern, currPath + "/")) {
                this.doRetrieveMatchingFiles(fullPattern, content, result);
            }
            if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
            result.add(content);
        }
    }
}

