/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.springframework.configuration.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.springframework.configuration.runtime.IServiceLocator;
import jetbrains.springframework.configuration.runtime.PlaceholderResolver;
import jetbrains.springframework.configuration.runtime.ServiceLocatorListener;
import jetbrains.springframework.configuration.runtime.VolatileServiceLocatorDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;

public class ServiceLocator {
    private static final Log log = LogFactory.getLog(ServiceLocator.class);
    private static final String CLASSPATH_PREFIX = "classpath";
    private static final String CLASSPATH_WILDCARD_PREFIX = "classpath*:**";
    private static final String CLASSPATH_REPLACE_PREFIX = "classpath*:";
    @NotNull
    private static IServiceLocator INSTANCE = new VolatileServiceLocatorDelegate();

    protected ServiceLocator() {
    }

    public static boolean isInited() {
        return !INSTANCE.isFake();
    }

    public static PlaceholderResolver getResolver() {
        return INSTANCE.getResolver();
    }

    public static Resource[] getResources(String pattern) throws IOException {
        return INSTANCE.getResourceLoader().getResources(pattern);
    }

    public static Object getBean(String id) {
        return INSTANCE.getBean(id);
    }

    @Deprecated
    public static boolean beanDefined(String id) {
        IServiceLocator locator = INSTANCE;
        if (locator.isFake()) {
            return false;
        }
        return locator.beanDefined(id);
    }

    @Deprecated
    public static void setTestBean(String id, Object testBeanImplementation) {
        INSTANCE.setTestBean(id, testBeanImplementation);
    }

    public static Object getOptionalBean(String id) {
        return INSTANCE.getOptionalBean(id);
    }

    public static synchronized void close() {
        if (INSTANCE.isFake()) {
            return;
        }
        IServiceLocator inst = VolatileServiceLocatorDelegate.INSTANCE;
        if (inst != null) {
            ServiceLocator.deinit();
            VolatileServiceLocatorDelegate.INSTANCE = null;
            inst.close();
        }
    }

    static void deinit() {
        INSTANCE = new VolatileServiceLocatorDelegate();
    }

    public static void closeLocal() {
        INSTANCE.closeLocal();
    }

    public static void init(IServiceLocator locator) {
        INSTANCE = locator;
        VolatileServiceLocatorDelegate.INSTANCE = locator;
        locator.init();
        ServiceLocator.fireAfterInit();
    }

    public static void fireLocalAfterInit() {
        Map listeners = ServiceLocator.getLocalBeansOfType(ServiceLocatorListener.class);
        List<String> orderedListenerNames = ServiceLocator.sortServiceLocatorListeners(listeners, ServiceLocator.checkMissingDependencies(listeners));
        for (String orderedListenerName : orderedListenerNames) {
            ServiceLocatorListener locatorListener = (ServiceLocatorListener)listeners.get(orderedListenerName);
            if (locatorListener == null) continue;
            locatorListener.onAfterInit();
        }
    }

    private static Map getLocalBeansOfType(Class type) {
        return INSTANCE.getLocalBeansOfType(type);
    }

    private static Map getBeansOfType(Class type) {
        return INSTANCE.getBeansOfType(type);
    }

    private static void fireAfterInit() {
        Map listeners = ServiceLocator.getBeansOfType(ServiceLocatorListener.class);
        List<String> orderedListenerNames = ServiceLocator.sortServiceLocatorListeners(listeners, ServiceLocator.checkMissingDependencies(listeners));
        for (String orderedListenerName : orderedListenerNames) {
            ServiceLocatorListener locatorListener = (ServiceLocatorListener)listeners.get(orderedListenerName);
            if (locatorListener == null) continue;
            locatorListener.onAfterInit();
        }
    }

    private static Collection<String> checkMissingDependencies(Map<String, ServiceLocatorListener> listeners) {
        HashMap<String, ArrayList<String>> missingDependencies = new HashMap<String, ArrayList<String>>();
        int missingDependenciesCount = 0;
        for (String listenerName : listeners.keySet()) {
            ServiceLocatorListener listener = listeners.get(listenerName);
            for (String dependeeName : listener.getDependeeNames()) {
                if (listeners.containsKey(dependeeName)) continue;
                ArrayList<String> names = (ArrayList<String>)missingDependencies.get(listenerName);
                if (names == null) {
                    names = new ArrayList<String>();
                    missingDependencies.put(listenerName, names);
                }
                names.add(dependeeName);
                ++missingDependenciesCount;
            }
        }
        if (!missingDependencies.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(missingDependenciesCount);
            StringBuilder builder = new StringBuilder();
            for (String listenerName : missingDependencies.keySet()) {
                for (String dependeeName : (List)missingDependencies.get(listenerName)) {
                    builder.append("Bean ").append(listenerName);
                    builder.append(" depends on bean ").append(dependeeName);
                    builder.append(" that couldn't be found in configuration\n");
                    result.add(dependeeName);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)builder.toString());
            }
            return result;
        }
        return null;
    }

    private static List<String> sortServiceLocatorListeners(Map<String, ServiceLocatorListener> listeners, Collection<String> missing) {
        ArrayList<String> orderedListenerNames = missing == null ? new ArrayList<String>(listeners.size()) : new ArrayList<String>(missing);
        HashMap<String, ServiceLocatorListener> _listeners = new HashMap<String, ServiceLocatorListener>(listeners);
        while (listeners.size() + (missing == null ? 0 : missing.size()) > orderedListenerNames.size()) {
            int numberOfOrdered = 0;
            Iterator i = _listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!orderedListenerNames.containsAll(((ServiceLocatorListener)entry.getValue()).getDependeeNames())) continue;
                ++numberOfOrdered;
                orderedListenerNames.add((String)entry.getKey());
                i.remove();
            }
            if (numberOfOrdered != 0) continue;
            throw new IllegalStateException("ServiceLocatorListeners " + listeners.keySet() + " has cyclic dependencies");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServiceLocatorListeners initialization order:");
            int i = 1;
            for (String s : orderedListenerNames) {
                log.debug((Object)("  " + i++ + " " + s + (missing != null && missing.contains(s) ? " (MISSING!)" : "")));
            }
        }
        return orderedListenerNames;
    }
}

