/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.dates.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import jetbrains.mps.internationalization.dates.runtime.LocalizedPeriodPrinter;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodPrinter;

public class LocalizedOffsetDateTimePrinter
implements DateTimePrinter {
    protected PeriodType periodType;
    protected PeriodFormatter periodFormatter;
    protected ReadableInstant reference;

    public LocalizedOffsetDateTimePrinter(DateTime reference, DurationFieldType ... types) {
        this.reference = reference;
        this.periodFormatter = new PeriodFormatter((PeriodPrinter)new LocalizedPeriodPrinter(), null);
        this.periodType = PeriodType.forFields((DurationFieldType[])types);
    }

    public int estimatePrintedLength() {
        return 100;
    }

    public void printTo(StringBuffer buffer, long l, Chronology chronology, int i, DateTimeZone zone, Locale locale) {
        buffer.append(this.getPresentation(this.toDateTime(l, i, zone), locale));
    }

    public void printTo(Writer writer, long l, Chronology chronology, int i, DateTimeZone zone, Locale locale) throws IOException {
        writer.write(this.getPresentation(this.toDateTime(l, i, zone), locale));
    }

    public void printTo(StringBuffer buffer, ReadablePartial partial, Locale locale) {
        buffer.append(this.getPresentation(new DateTime((Object)partial), locale));
    }

    public void printTo(Writer writer, ReadablePartial partial, Locale locale) throws IOException {
        writer.write(this.getPresentation(new DateTime((Object)partial), locale));
    }

    protected String getPresentation(DateTime dateTime, Locale locale) {
        String period = this.periodFormatter.withLocale(locale).print((ReadablePeriod)this.toPreiod(dateTime));
        return this.isBefore(dateTime) ? this.getBefore(locale, period) : this.getAfter(locale, period);
    }

    protected boolean isBefore(DateTime dateTime) {
        return this.reference == null ? dateTime.isBeforeNow() : dateTime.compareTo(this.reference) < 0;
    }

    protected Period toPreiod(DateTime dateTime) {
        return this.isBefore(dateTime) ? new Period((ReadableInstant)dateTime, this.reference, this.periodType) : new Period(this.reference, (ReadableInstant)dateTime, this.periodType);
    }

    protected DateTime toDateTime(long instant, int displayOffset, DateTimeZone displayZone) {
        DateTime dateTime = new DateTime(instant - (long)displayOffset, displayZone);
        return dateTime;
    }

    private String getBefore(Locale locale, String period) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("internationalization.dates.before", locale, new Object[]{period});
    }

    private String getAfter(Locale locale, String period) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("internationalization.dates.after", locale, new Object[]{period});
    }
}

