/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.io;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/core/io/SizeLimitingInputStream;", "Ljava/io/InputStream;", "originalStream", "sizeLimit", "", "getException", "Lkotlin/Function0;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/io/InputStream;JLkotlin/jvm/functions/Function0;)V", "runningSize", "close", "", "read", "", "Companion", "jetbrains.jetpass.core"})
public final class SizeLimitingInputStream
extends InputStream {
    private long runningSize;
    private final InputStream originalStream;
    private final long sizeLimit;
    private final Function0<Exception> getException;
    public static final long DEFAULT_SIZE_LIMIT = 0x100000L;
    public static final Companion Companion = new Companion(null);

    @Override
    public int read() {
        int n = this.originalStream.read();
        int it = n;
        if (it != -1) {
            SizeLimitingInputStream sizeLimitingInputStream = this;
            ++sizeLimitingInputStream.runningSize;
            if (sizeLimitingInputStream.runningSize > this.sizeLimit) {
                throw (Throwable)this.getException.invoke();
            }
        }
        return n;
    }

    @Override
    public void close() {
        this.originalStream.close();
    }

    public SizeLimitingInputStream(@NotNull InputStream originalStream, long sizeLimit, @NotNull Function0<? extends Exception> getException) {
        Intrinsics.checkParameterIsNotNull((Object)originalStream, (String)"originalStream");
        Intrinsics.checkParameterIsNotNull(getException, (String)"getException");
        this.originalStream = originalStream;
        this.sizeLimit = sizeLimit;
        this.getException = getException;
    }

    public /* synthetic */ SizeLimitingInputStream(InputStream inputStream, long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0x100000L;
        }
        this(inputStream, l, (Function0<? extends Exception>)function0);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/core/io/SizeLimitingInputStream$Companion;", "", "()V", "DEFAULT_SIZE_LIMIT", "", "jetbrains.jetpass.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

