/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.io;

import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/core/io/SizeLimitingReader;", "Ljava/io/Reader;", "source", "maxSize", "", "getException", "Lkotlin/Function0;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/io/Reader;JLkotlin/jvm/functions/Function0;)V", "runningSize", "close", "", "read", "", "cbuf", "", "off", "len", "jetbrains.jetpass.core"})
public final class SizeLimitingReader
extends Reader {
    private long runningSize;
    private final Reader source;
    private final long maxSize;
    private final Function0<Exception> getException;

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public int read(@Nullable char[] cbuf, int off, int len) {
        int n = this.source.read(cbuf, off, len);
        int it = n;
        if (it != -1) {
            this.runningSize += (long)it;
            if (this.runningSize > this.maxSize) {
                throw (Throwable)this.getException.invoke();
            }
        }
        return n;
    }

    public SizeLimitingReader(@NotNull Reader source, long maxSize, @NotNull Function0<? extends Exception> getException) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(getException, (String)"getException");
        this.source = source;
        this.maxSize = maxSize;
        this.getException = getException;
    }
}

