/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.security.cert;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.net.URLDecoder;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import jetbrains.jetpass.core.lang.CommonExtKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.X500Name;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"factory", "Ljava/security/cert/CertificateFactory;", "kotlin.jvm.PlatformType", "deserializePemToX509", "Ljava/security/cert/X509Certificate;", "pemString", "", "extractSubjectDnRdn", "rdn", "searchInSubjectDNByName", "name", "searchInSubjectDNByOid", "oid", "serializeToPEM", "thumbprint", "jetbrains.jetpass.core"})
public final class CertificateUtilsKt {
    private static final CertificateFactory factory = CertificateFactory.getInstance("X.509");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final X509Certificate deserializePemToX509(@NotNull String pemString) {
        X509Certificate x509Certificate;
        String decoded;
        Intrinsics.checkParameterIsNotNull((Object)pemString, (String)"pemString");
        String string = decoded = StringsKt.contains$default((CharSequence)pemString, (CharSequence)"\n", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)pemString, (CharSequence)"\r", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)pemString, (CharSequence)" ", (boolean)false, (int)2, null) ? pemString : URLDecoder.decode(pemString, Charsets.UTF_8.name());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decoded");
        String firstPem = StringsKt.substringBefore$default((String)string, (String)"-----END CERTIFICATE-----", null, (int)2, null);
        Object object = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.replace$default((String)firstPem, (String)"\n", (String)"", (boolean)false, (int)4, null), (CharSequence)"-----BEGIN CERTIFICATE-----"), (CharSequence)"-----END CERTIFICATE-----");
        String string2 = object;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        byte[] certBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
        object = new ByteArrayInputStream(certBytes);
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)object;
            x509Certificate = (X509Certificate)CommonExtKt.asInstanceOf(factory.generateCertificate(it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return x509Certificate;
    }

    @NotNull
    public static final String serializeToPEM(@NotNull X509Certificate $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "-----BEGIN CERTIFICATE-----\n" + Base64.getEncoder().encodeToString($receiver.getEncoded()) + "\n" + "-----END CERTIFICATE-----";
    }

    @NotNull
    public static final String thumbprint(@NotNull X509Certificate $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = DigestUtils.sha1Hex((byte[])$receiver.getEncoded());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.sha1Hex(this.encoded)");
        return string;
    }

    @Nullable
    public static final String extractSubjectDnRdn(@NotNull X509Certificate $receiver, @NotNull String rdn) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)rdn, (String)"rdn");
        String string = CertificateUtilsKt.searchInSubjectDNByOid($receiver, rdn);
        if (string == null) {
            string = CertificateUtilsKt.searchInSubjectDNByName($receiver, rdn);
        }
        return string;
    }

    @Nullable
    public static final String searchInSubjectDNByOid(@NotNull X509Certificate $receiver, @NotNull String oid) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)oid, (String)"oid");
        try {
            Object object;
            Principal principal = $receiver.getSubjectDN();
            if (!(principal instanceof X500Name)) {
                principal = null;
            }
            string = (object = (X500Name)principal) != null && (object = ((X500Name)object).findMostSpecificAttribute(new ObjectIdentifier(StringsKt.removePrefix((String)oid, (CharSequence)"OID.")))) != null ? ((DerValue)object).getAsString() : null;
        }
        catch (Exception ex) {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String searchInSubjectDNByName(@NotNull X509Certificate $receiver, @NotNull String name) {
        Object object;
        Object v3;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Principal principal = $receiver.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"this.subjectDN");
            List<Rdn> list = new LdapName(principal.getName()).getRdns();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"LdapName(this.subjectDN.name)\n            .rdns");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Rdn it;
                Rdn rdn = it = (Rdn)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)rdn, (String)"it");
                if (!Intrinsics.areEqual((Object)rdn.getType(), (Object)name)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return (object = (Rdn)v3) != null && (object = ((Rdn)object).getValue()) != null ? object.toString() : null;
    }
}

