/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.security.cert;

import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 \u00122\u00060\u0001j\u0002`\u0002:\u0001\u0012BM\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012*\u0010\b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/core/security/cert/CertificateValidationException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "code", "", "message", "cause", "", "params", "", "Lkotlin/Pair;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;[Lkotlin/Pair;)V", "getCode", "()Ljava/lang/String;", "parameters", "", "getParameters", "()Ljava/util/Map;", "Companion", "jetbrains.jetpass.core"})
public final class CertificateValidationException
extends RuntimeException {
    @NotNull
    private final Map<String, String> parameters;
    @NotNull
    private final String code;
    private static final SimpleDateFormat DATE_FORMAT;
    @NotNull
    public static final String CERT_EXPIRED = "validation-certificate-expired";
    @NotNull
    public static final String CERT_NOT_YET_VALID = "validation-certificate-not-yet-valid";
    @NotNull
    public static final String CERT_ISSUER_NOT_TRUSTED = "validation-certificate-issuer-not-trusted";
    @NotNull
    public static final String CERT_REVOKED = "validation-certificate-revoked";
    @NotNull
    public static final String REVOCATION_LIST_INACCESSIBLE = "validation-certificate-revocation-list-inaccessible";
    @NotNull
    public static final String FAILED_TO_VALIDATE = "validation-certificate-failed";
    @NotNull
    public static final String TRUSTED_ISSUERS_REQUIRED = "validation-certificate-trusted-issuers-required";
    @NotNull
    public static final String CA_NOT_ALLOWED = "validation-certificate-ca-not-allowed";
    public static final Companion Companion;

    @NotNull
    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    private CertificateValidationException(String code, String message, Throwable cause, Pair<String, String> ... params) {
        super(message, cause);
        this.code = code;
        this.parameters = MapsKt.toMap(params);
    }

    static {
        Companion = new Companion(null);
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm");
    }

    public /* synthetic */ CertificateValidationException(@NotNull String code, @NotNull String message, @Nullable Throwable cause, @NotNull Pair[] params,  /* corrupt varargs signature?! */ DefaultConstructorMarkerDefaultConstructorMarker $constructor_marker) {
        this(code, message, cause, params);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\"\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\n\u0010\u0014\u001a\u00060\u001aj\u0002`\u001bJ\"\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\n\u0010\u0014\u001a\u00060\u001aj\u0002`\u001bJ*\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\n\u0010\u0014\u001a\u00060\u001aj\u0002`\u001bJ\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/core/security/cert/CertificateValidationException$Companion;", "", "()V", "CA_NOT_ALLOWED", "", "CERT_EXPIRED", "CERT_ISSUER_NOT_TRUSTED", "CERT_NOT_YET_VALID", "CERT_REVOKED", "DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "FAILED_TO_VALIDATE", "REVOCATION_LIST_INACCESSIBLE", "TRUSTED_ISSUERS_REQUIRED", "caNotAllowed", "Ljetbrains/jetpass/core/security/cert/CertificateValidationException;", "certificate", "Ljava/security/cert/X509Certificate;", "presentation", "certExpired", "cause", "Ljava/security/cert/CertificateExpiredException;", "certNotYetValid", "Ljava/security/cert/CertificateNotYetValidException;", "certRevoked", "failedValidation", "Ljava/lang/Exception;", "Lkotlin/Exception;", "notTrustedChain", "revocationListInaccessible", "crlUrl", "trustedIssuersRequired", "jetbrains.jetpass.core"})
    public static final class Companion {
        @NotNull
        public final CertificateValidationException notTrustedChain(@NotNull X509Certificate certificate, @NotNull String presentation, @NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = "The issuer of the [" + presentation + "] certificate is not trusted or the certificate signature is invalid";
            Throwable throwable = cause;
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            Principal principal2 = certificate.getIssuerDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal2, (String)"certificate.issuerDN");
            pairArray[2] = TuplesKt.to((Object)"issuerDn", (Object)principal2.getName());
            return new CertificateValidationException(CertificateValidationException.CERT_ISSUER_NOT_TRUSTED, string, throwable, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException failedValidation(@NotNull X509Certificate certificate, @NotNull String presentation, @NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = "Failed to validate [" + presentation + "] certificate";
            Throwable throwable = cause;
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            Principal principal2 = certificate.getIssuerDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal2, (String)"certificate.issuerDN");
            pairArray[2] = TuplesKt.to((Object)"issuerDn", (Object)principal2.getName());
            return new CertificateValidationException(CertificateValidationException.FAILED_TO_VALIDATE, string, throwable, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException certNotYetValid(@NotNull X509Certificate certificate, @NotNull String presentation, @NotNull CertificateNotYetValidException cause) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = "Certificate [" + presentation + "] is not valid until " + DATE_FORMAT.format(certificate.getNotBefore()) + " GMT";
            Throwable throwable = cause;
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            Date date = certificate.getNotBefore();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"certificate.notBefore");
            pairArray[2] = TuplesKt.to((Object)"notBefore", (Object)String.valueOf(date.getTime()));
            return new CertificateValidationException(CertificateValidationException.CERT_NOT_YET_VALID, string, throwable, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException certExpired(@NotNull X509Certificate certificate, @NotNull String presentation, @NotNull CertificateExpiredException cause) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = "Certificate [" + presentation + "] is not valid after " + DATE_FORMAT.format(certificate.getNotAfter()) + " GMT";
            Throwable throwable = cause;
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            Date date = certificate.getNotAfter();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"certificate.notAfter");
            pairArray[2] = TuplesKt.to((Object)"notAfter", (Object)String.valueOf(date.getTime()));
            return new CertificateValidationException(CertificateValidationException.CERT_EXPIRED, string, throwable, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException certRevoked(@NotNull X509Certificate certificate, @NotNull String presentation) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            String string = "Certificate [" + presentation + "] was revoked";
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            return new CertificateValidationException(CertificateValidationException.CERT_REVOKED, string, null, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException revocationListInaccessible(@NotNull X509Certificate certificate, @NotNull String presentation, @NotNull String crlUrl, @NotNull Exception cause) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            Intrinsics.checkParameterIsNotNull((Object)crlUrl, (String)"crlUrl");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            String string = "Revocation list [" + crlUrl + "] of certificate [" + presentation + "] is not accessible";
            Throwable throwable = cause;
            Pair[] pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            pairArray[2] = TuplesKt.to((Object)"crlUrl", (Object)crlUrl);
            String string2 = cause.getMessage();
            if (string2 == null) {
                string2 = "empty";
            }
            pairArray[3] = TuplesKt.to((Object)"cause", (Object)string2);
            return new CertificateValidationException(CertificateValidationException.REVOCATION_LIST_INACCESSIBLE, string, throwable, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException trustedIssuersRequired(@NotNull X509Certificate certificate, @NotNull String presentation) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            String string = "Couldn't validate certificate [" + presentation + "] because no trusted issuers were found";
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            return new CertificateValidationException(CertificateValidationException.TRUSTED_ISSUERS_REQUIRED, string, null, pairArray, null);
        }

        @NotNull
        public final CertificateValidationException caNotAllowed(@NotNull X509Certificate certificate, @NotNull String presentation) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            String string = "Certificate [" + presentation + "] is not valid as you can't use CA or intermediate certificates for authentication";
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"presentation", (Object)presentation);
            Principal principal = certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"certificate.subjectDN");
            pairArray[1] = TuplesKt.to((Object)"subjectDn", (Object)principal.getName());
            return new CertificateValidationException(CertificateValidationException.CA_NOT_ALLOWED, string, null, pairArray, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

