/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.security.cert;

import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jetbrains.jetpass.core.security.cert.CertificateValidationException;
import jetbrains.jetpass.core.security.cert.CertificateValidatorKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J,\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00020\u0010*\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/core/security/cert/CertificateValidator;", "Lmu/KLogging;", "()V", "assertDates", "", "certificate", "Ljetbrains/jetpass/core/security/cert/CertificateValidator$Cert;", "assertNotCA", "assertRevocation", "assertTrustedIssuers", "trustedIssuers", "", "Ljava/security/cert/X509Certificate;", "intermediates", "validate", "emailRdn", "", "toPemString", "Cert", "jetbrains.jetpass.core"})
public final class CertificateValidator
extends KLogging {
    public static final CertificateValidator INSTANCE;

    public final void validate(@NotNull X509Certificate certificate, @NotNull List<? extends X509Certificate> trustedIssuers, @NotNull List<? extends X509Certificate> intermediates, @NotNull String emailRdn) {
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        Intrinsics.checkParameterIsNotNull(trustedIssuers, (String)"trustedIssuers");
        Intrinsics.checkParameterIsNotNull(intermediates, (String)"intermediates");
        Intrinsics.checkParameterIsNotNull((Object)emailRdn, (String)"emailRdn");
        String presentation = CertificateValidatorKt.getPresentation(certificate, emailRdn);
        Cert cert = new Cert(certificate, presentation);
        this.assertNotCA(cert);
        this.assertDates(cert);
        this.assertTrustedIssuers(cert, trustedIssuers, intermediates);
        this.assertRevocation(cert);
    }

    private final void assertNotCA(Cert certificate) {
        boolean[] keyUsage = certificate.getX509().getKeyUsage();
        if (keyUsage != null && keyUsage[5]) {
            throw (Throwable)CertificateValidationException.Companion.caNotAllowed(certificate.getX509(), certificate.getPresentation());
        }
    }

    private final void assertDates(Cert certificate) {
        Date date = Date.from(ZonedDateTime.now(ZoneOffset.UTC).toInstant());
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"Date.from(ZonedDateTime.\u2026eOffset.UTC).toInstant())");
        Date now = date;
        try {
            certificate.getX509().checkValidity(now);
        }
        catch (CertificateExpiredException ex) {
            throw (Throwable)CertificateValidationException.Companion.certExpired(certificate.getX509(), certificate.getPresentation(), ex);
        }
        catch (CertificateNotYetValidException ex) {
            throw (Throwable)CertificateValidationException.Companion.certNotYetValid(certificate.getX509(), certificate.getPresentation(), ex);
        }
    }

    private final void assertRevocation(Cert certificate) {
    }

    /*
     * WARNING - void declaration
     */
    private final void assertTrustedIssuers(Cert certificate, List<? extends X509Certificate> trustedIssuers, List<? extends X509Certificate> intermediates) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        X509CertSelector x509CertSelector;
        if (trustedIssuers.isEmpty()) {
            throw (Throwable)CertificateValidationException.Companion.trustedIssuersRequired(certificate.getX509(), certificate.getPresentation());
        }
        X509CertSelector $receiver = x509CertSelector = new X509CertSelector();
        $receiver.setCertificate(certificate.getX509());
        X509CertSelector selector = x509CertSelector;
        Iterable $i$a$1$apply = $receiver$iv = (Iterable)trustedIssuers;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            TrustAnchor trustAnchor = new TrustAnchor((X509Certificate)it, null);
            collection.add(trustAnchor);
        }
        Set trustedAnchors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List certStoreParametersTypedCollection = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)certificate.getX509()), (Iterable)intermediates);
        CertStore intermediatesStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certStoreParametersTypedCollection), "BC");
        Object $receiver2 = object = new PKIXBuilderParameters(trustedAnchors, (CertSelector)selector);
        ((PKIXParameters)$receiver2).setRevocationEnabled(false);
        ((PKIXParameters)$receiver2).addCertStore(intermediatesStore);
        Object pkixParams = object;
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
        try {
            CertPathBuilderResult certPathBuilderResult = builder.build((CertPathParameters)pkixParams);
            if (certPathBuilderResult == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.PKIXCertPathBuilderResult");
            }
            PKIXCertPathBuilderResult cfr_ignored_0 = (PKIXCertPathBuilderResult)certPathBuilderResult;
        }
        catch (CertPathBuilderException ex) {
            this.getLogger().debug((Function0)new Function0<String>(certificate){
                final /* synthetic */ Cert $certificate;

                @NotNull
                public final String invoke() {
                    return "Failed to validate [" + this.$certificate.getPresentation() + "]: " + CertificateValidator.access$toPemString(CertificateValidator.INSTANCE, this.$certificate.getX509());
                }
                {
                    this.$certificate = cert;
                    super(0);
                }
            });
            throw (Throwable)CertificateValidationException.Companion.notTrustedChain(certificate.getX509(), certificate.getPresentation(), ex);
        }
        catch (Exception ex) {
            throw (Throwable)CertificateValidationException.Companion.failedValidation(certificate.getX509(), certificate.getPresentation(), ex);
        }
    }

    private final String toPemString(@NotNull X509Certificate $receiver) {
        byte[] bytes = $receiver.getEncoded();
        return "-----BEGIN CERTIFICATE-----" + Base64.getEncoder().encodeToString(bytes) + "-----END CERTIFICATE-----";
    }

    private CertificateValidator() {
    }

    static {
        CertificateValidator certificateValidator;
        INSTANCE = certificateValidator = new CertificateValidator();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @NotNull
    public static final /* synthetic */ String access$toPemString(CertificateValidator $this, @NotNull X509Certificate $receiver) {
        return $this.toPemString($receiver);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/core/security/cert/CertificateValidator$Cert;", "", "x509", "Ljava/security/cert/X509Certificate;", "presentation", "", "(Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "getPresentation", "()Ljava/lang/String;", "getX509", "()Ljava/security/cert/X509Certificate;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jetbrains.jetpass.core"})
    private static final class Cert {
        @NotNull
        private final X509Certificate x509;
        @NotNull
        private final String presentation;

        @NotNull
        public final X509Certificate getX509() {
            return this.x509;
        }

        @NotNull
        public final String getPresentation() {
            return this.presentation;
        }

        public Cert(@NotNull X509Certificate x509, @NotNull String presentation) {
            Intrinsics.checkParameterIsNotNull((Object)x509, (String)"x509");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            this.x509 = x509;
            this.presentation = presentation;
        }

        @NotNull
        public final X509Certificate component1() {
            return this.x509;
        }

        @NotNull
        public final String component2() {
            return this.presentation;
        }

        @NotNull
        public final Cert copy(@NotNull X509Certificate x509, @NotNull String presentation) {
            Intrinsics.checkParameterIsNotNull((Object)x509, (String)"x509");
            Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
            return new Cert(x509, presentation);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Cert copy$default(Cert cert, X509Certificate x509Certificate, String string, int n, Object object) {
            if ((n & 1) != 0) {
                x509Certificate = cert.x509;
            }
            if ((n & 2) != 0) {
                string = cert.presentation;
            }
            return cert.copy(x509Certificate, string);
        }

        public String toString() {
            return "Cert(x509=" + this.x509 + ", presentation=" + this.presentation + ")";
        }

        public int hashCode() {
            X509Certificate x509Certificate = this.x509;
            String string = this.presentation;
            return (x509Certificate != null ? ((Object)x509Certificate).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Cert)) break block3;
                    Cert cert = (Cert)object;
                    if (!Intrinsics.areEqual((Object)this.x509, (Object)cert.x509) || !Intrinsics.areEqual((Object)this.presentation, (Object)cert.presentation)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

