/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.security.cert;

import java.security.Principal;
import java.security.cert.X509Certificate;
import jetbrains.jetpass.core.security.cert.CertificateUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"getPresentation", "", "Ljava/security/cert/X509Certificate;", "emailRdn", "jetbrains.jetpass.core"})
public final class CertificateValidatorKt {
    @NotNull
    public static final String getPresentation(@NotNull X509Certificate $receiver, @NotNull String emailRdn) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)emailRdn, (String)"emailRdn");
        String email = CertificateUtilsKt.extractSubjectDnRdn($receiver, emailRdn);
        String commonName = CertificateUtilsKt.extractSubjectDnRdn($receiver, "CN");
        if (email != null && commonName != null) {
            string = "[Name: " + commonName + ", Email: " + email + ']';
        } else {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Principal principal = $receiver.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"this.subjectDN");
            string = stringBuilder.append(principal.getName()).append(']').toString();
        }
        return string;
    }
}

