/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.store;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.commons.lang.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u001f\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\f\u00a2\u0006\u0002\u0010!J\u0013\u0010#\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR0\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00000\rR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Ljetbrains/jetpass/core/store/OneTimeStore;", "D", "", "()V", "keyLength", "", "getKeyLength", "()I", "setKeyLength", "(I)V", "store", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljetbrains/jetpass/core/store/OneTimeStore$ItemContainer;", "getStore", "()Ljava/util/concurrent/ConcurrentHashMap;", "ttl", "", "getTtl", "()J", "setTtl", "(J)V", "clean", "", "find", "key", "remove", "", "(Ljava/lang/String;Z)Ljava/lang/Object;", "generateAndPut", "item", "(Ljava/lang/Object;)Ljava/lang/String;", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "peek", "put", "Companion", "ItemContainer", "jetbrains.jetpass.core"})
public class OneTimeStore<D> {
    private long ttl = TIME_TO_LIVE;
    private int keyLength = KEY_LENGTH;
    @NotNull
    private final ConcurrentHashMap<String, ItemContainer<D>> store = new ConcurrentHashMap();
    private static final int KEY_LENGTH = 8;
    private static final int MAX_RETRIES = 10;
    private static final long TIME_TO_LIVE = 600000L;
    public static final Companion Companion = new Companion(null);

    public final long getTtl() {
        return this.ttl;
    }

    public final void setTtl(long l) {
        this.ttl = l;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }

    public final void setKeyLength(int n) {
        this.keyLength = n;
    }

    @NotNull
    public ConcurrentHashMap<String, ItemContainer<D>> getStore() {
        return this.store;
    }

    @NotNull
    public final String put(D item) {
        this.clean();
        return this.generateAndPut(item);
    }

    @Nullable
    public final D get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.find(key, true);
    }

    @Nullable
    public final D peek(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.find(key, false);
    }

    private final D find(String key, boolean remove) {
        Object v1;
        ItemContainer<D> itemContainer = this.getStore().get(key);
        if (itemContainer != null) {
            ItemContainer<D> itemContainer2 = itemContainer;
            ItemContainer<D> container = itemContainer2;
            if (container.isExpired()) {
                this.getStore().remove(key);
                v1 = null;
            } else {
                if (remove) {
                    this.getStore().remove(key);
                }
                v1 = container.getItem();
            }
        } else {
            v1 = null;
        }
        return v1;
    }

    private final String generateAndPut(D item) {
        long expiration = System.currentTimeMillis() + this.ttl;
        int n = 1;
        Iterable $receiver$iv = (Iterable)new IntRange(n, MAX_RETRIES);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            String key = RandomStringUtils.randomAlphanumeric((int)this.keyLength);
            if (this.getStore().putIfAbsent(key, new ItemContainer<D>(item, expiration)) != null) continue;
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            return string;
        }
        throw (Throwable)new RuntimeException("Failed to generate unique key after " + MAX_RETRIES + " retries");
    }

    private final void clean() {
        Iterator<ItemContainer<D>> i = this.getStore().values().iterator();
        while (i.hasNext()) {
            ItemContainer<D> container = i.next();
            if (!container.isExpired()) continue;
            i.remove();
        }
    }

    static {
        KEY_LENGTH = 8;
        MAX_RETRIES = 10;
        TIME_TO_LIVE = 600000L;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/core/store/OneTimeStore$ItemContainer;", "D", "", "item", "expiration", "", "(Ljetbrains/jetpass/core/store/OneTimeStore;Ljava/lang/Object;J)V", "getExpiration", "()J", "isExpired", "", "()Z", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "jetbrains.jetpass.core"})
    public final class ItemContainer<D> {
        private final D item;
        private final long expiration;

        public final boolean isExpired() {
            return System.currentTimeMillis() > this.expiration;
        }

        public final D getItem() {
            return this.item;
        }

        public final long getExpiration() {
            return this.expiration;
        }

        public ItemContainer(D item, long expiration) {
            this.item = item;
            this.expiration = expiration;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljetbrains/jetpass/core/store/OneTimeStore$Companion;", "", "()V", "KEY_LENGTH", "", "getKEY_LENGTH", "()I", "MAX_RETRIES", "getMAX_RETRIES", "TIME_TO_LIVE", "", "getTIME_TO_LIVE", "()J", "jetbrains.jetpass.core"})
    public static final class Companion {
        public final int getKEY_LENGTH() {
            return KEY_LENGTH;
        }

        public final int getMAX_RETRIES() {
            return MAX_RETRIES;
        }

        public final long getTIME_TO_LIVE() {
            return TIME_TO_LIVE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

