/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.threading;

import java.io.Closeable;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.jetpass.core.threading.IdentifierLocks;
import jetbrains.jetpass.core.time.DurationExtKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ'\u0010\u0014\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0016\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\rJ\f\u0010\u001c\u001a\u00020\u001d*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/core/threading/IdentifierLocks;", "", "gcRate", "", "gcAge", "Ljava/time/Duration;", "(ILjava/time/Duration;)V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "gcLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "locks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljetbrains/jetpass/core/threading/IdentifierLocks$TimestampedLock;", "logger", "Lmu/KLogger;", "cleanLocks", "", "incrementCounter", "lock", "Ljava/io/Closeable;", "id", "T", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "release", "isInactive", "", "Lock", "TimestampedLock", "jetbrains.jetpass.core"})
public final class IdentifierLocks {
    private final ConcurrentHashMap<String, TimestampedLock> locks;
    private final KLogger logger;
    private AtomicInteger counter;
    private final ReentrantReadWriteLock gcLock;
    private final int gcRate;
    private final Duration gcAge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Closeable lock(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.gcLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            TimestampedLock timestampedLock;
            TimestampedLock it = timestampedLock = new TimestampedLock();
            TimestampedLock timestampedLock2 = this.locks.putIfAbsent(id, it);
            if (timestampedLock2 == null) {
                timestampedLock2 = it;
            }
            TimestampedLock lock = timestampedLock2;
            lock.lock();
            Closeable closeable = new Lock(id);
            return closeable;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T lock(@NotNull String id, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Closeable closeable = this.lock(id);
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            object = action.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    public final void release(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        TimestampedLock timestampedLock = this.locks.get(id);
        if (timestampedLock != null) {
            timestampedLock.unlock();
        }
        if (this.incrementCounter() == 0) {
            this.cleanLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanLocks() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.gcLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            int locksBefore = this.locks.size();
            if (locksBefore > 0) {
                Enumeration<String> enumeration = this.locks.keys();
                Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"locks.keys()");
                Object object = enumeration;
                List freeLockKeys = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(object)), (Function1)((Function1)new Function1<String, Boolean>(this){
                    final /* synthetic */ IdentifierLocks this$0;
                    {
                        this.this$0 = identifierLocks;
                        super(1);
                    }

                    public final boolean invoke(String key) {
                        boolean bl;
                        TimestampedLock timestampedLock = (TimestampedLock)IdentifierLocks.access$getLocks$p(this.this$0).get(key);
                        if (timestampedLock != null) {
                            TimestampedLock timestampedLock2;
                            TimestampedLock it;
                            TimestampedLock timestampedLock3 = it = (timestampedLock2 = timestampedLock);
                            Intrinsics.checkExpressionValueIsNotNull((Object)timestampedLock3, (String)"it");
                            bl = !timestampedLock3.isLocked() && IdentifierLocks.access$isInactive(this.this$0, it);
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                })));
                Iterable $receiver$iv = freeLockKeys;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    this.locks.remove(it);
                }
                object = freeLockKeys;
                if (!object.isEmpty()) {
                    this.logger.debug((Function0)new Function0<String>(freeLockKeys, locksBefore){
                        final /* synthetic */ List $freeLockKeys;
                        final /* synthetic */ int $locksBefore;

                        @NotNull
                        public final String invoke() {
                            return this.$freeLockKeys.size() + " out of " + this.$locksBefore + " locks were removed because they are inactive";
                        }
                        {
                            this.$freeLockKeys = list;
                            this.$locksBefore = n;
                            super(0);
                        }
                    });
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final boolean isInactive(@NotNull TimestampedLock $receiver) {
        return System.currentTimeMillis() - $receiver.getTimestamp() > this.gcAge.toMillis();
    }

    private final int incrementCounter() {
        int next;
        int current;
        while (!this.counter.compareAndSet(current, next = (current = this.counter.get()) >= this.gcRate ? 0 : current + 1)) {
        }
        return next;
    }

    public IdentifierLocks(int gcRate, @NotNull Duration gcAge) {
        Intrinsics.checkParameterIsNotNull((Object)gcAge, (String)"gcAge");
        this.gcRate = gcRate;
        this.gcAge = gcAge;
        this.locks = new ConcurrentHashMap();
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.counter = new AtomicInteger(1);
        this.gcLock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ IdentifierLocks(int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        if ((n2 & 2) != 0) {
            duration = DurationExtKt.getMinute(1);
        }
        this(n, duration);
    }

    public IdentifierLocks() {
        this(0, null, 3, null);
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getLocks$p(IdentifierLocks $this) {
        return $this.locks;
    }

    public static final /* synthetic */ boolean access$isInactive(IdentifierLocks $this, @NotNull TimestampedLock $receiver) {
        return $this.isInactive($receiver);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/core/threading/IdentifierLocks$TimestampedLock;", "Ljava/util/concurrent/locks/ReentrantLock;", "()V", "<set-?>", "", "timestamp", "getTimestamp", "()J", "setTimestamp", "(J)V", "lock", "", "jetbrains.jetpass.core"})
    private static final class TimestampedLock
    extends ReentrantLock {
        private long timestamp = System.currentTimeMillis();

        public final long getTimestamp() {
            return this.timestamp;
        }

        private final void setTimestamp(long l) {
            this.timestamp = l;
        }

        @Override
        public void lock() {
            super.lock();
            this.timestamp = System.currentTimeMillis();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/core/threading/IdentifierLocks$Lock;", "Ljava/io/Closeable;", "id", "", "(Ljetbrains/jetpass/core/threading/IdentifierLocks;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "close", "", "jetbrains.jetpass.core"})
    private final class Lock
    implements Closeable {
        @NotNull
        private final String id;

        @Override
        public void close() {
            IdentifierLocks.this.release(this.id);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public Lock(String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.id = id;
        }
    }
}

