/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.threading;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/core/threading/NamedThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadName", "", "daemonThreads", "", "(Ljava/lang/String;Z)V", "poolName", "delegate", "(Ljava/lang/String;ZLjava/util/concurrent/ThreadFactory;)V", "getDaemonThreads", "()Z", "getDelegate", "()Ljava/util/concurrent/ThreadFactory;", "getPoolName", "()Ljava/lang/String;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "jetbrains.jetpass.core"})
public final class NamedThreadFactory
implements ThreadFactory {
    @NotNull
    private final String poolName;
    private final boolean daemonThreads;
    @NotNull
    private final ThreadFactory delegate;

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Thread thread;
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Thread thread2 = thread = this.delegate.newThread(r);
        Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"thread");
        String string = thread.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"thread.name");
        thread2.setName(StringsKt.replace$default((String)string, (String)"pool", (String)this.poolName, (boolean)false, (int)4, null));
        thread.setDaemon(this.daemonThreads);
        return thread;
    }

    @NotNull
    public final String getPoolName() {
        return this.poolName;
    }

    public final boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    @NotNull
    public final ThreadFactory getDelegate() {
        return this.delegate;
    }

    public NamedThreadFactory(@NotNull String poolName, boolean daemonThreads, @NotNull ThreadFactory delegate) {
        Intrinsics.checkParameterIsNotNull((Object)poolName, (String)"poolName");
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.poolName = poolName;
        this.daemonThreads = daemonThreads;
        this.delegate = delegate;
    }

    public NamedThreadFactory(@NotNull String threadName, boolean daemonThreads) {
        Intrinsics.checkParameterIsNotNull((Object)threadName, (String)"threadName");
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadFactory, (String)"Executors.defaultThreadFactory()");
        this(threadName, daemonThreads, threadFactory);
    }

    public /* synthetic */ NamedThreadFactory(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }
}

