/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.threading;

import jetbrains.jetpass.core.threading.Observable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B)\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00028\u00002\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00028\u00002\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0016\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/jetpass/core/threading/ThreadLocalProperty;", "R", "T", "Lkotlin/properties/ReadWriteProperty;", "hostClassName", "", "removeObservable", "Ljetbrains/jetpass/core/threading/Observable;", "initialValue", "Lkotlin/Function0;", "(Ljava/lang/String;Ljetbrains/jetpass/core/threading/Observable;Lkotlin/jvm/functions/Function0;)V", "getHostClassName", "()Ljava/lang/String;", "prop", "Ljava/lang/ThreadLocal;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "setValue", "", "value", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "jetbrains.jetpass.core"})
public final class ThreadLocalProperty<R, T>
implements ReadWriteProperty<R, T> {
    private final ThreadLocal<T> prop;
    @Nullable
    private final String hostClassName;

    public T getValue(R thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        T value = this.prop.get();
        if (value == null && !property.getReturnType().isMarkedNullable()) {
            throw (Throwable)new RuntimeException("Thread local value " + this.hostClassName + '#' + property.getName() + " is null in the " + Thread.currentThread() + " thread");
        }
        return value;
    }

    public void setValue(R thisRef, @NotNull KProperty<?> property, T value) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        if (value == null) {
            this.prop.remove();
        } else {
            this.prop.set(value);
        }
    }

    @Nullable
    public final String getHostClassName() {
        return this.hostClassName;
    }

    public ThreadLocalProperty(@Nullable String hostClassName, @Nullable Observable removeObservable, @Nullable Function0<? extends T> initialValue) {
        block0: {
            this.hostClassName = hostClassName;
            this.prop = initialValue != null ? (ThreadLocal)new ThreadLocal<T>(initialValue){
                final /* synthetic */ Function0 $initialValue;

                protected T initialValue() {
                    return (T)this.$initialValue.invoke();
                }
                {
                    this.$initialValue = $captured_local_variable$0;
                }
            } : new ThreadLocal();
            Observable observable = removeObservable;
            if (observable == null) break block0;
            observable.subscribe((Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    prop.remove();
                }
            }));
        }
    }
}

