/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.throttling;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.jetpass.core.lang.PreconditionsKt;
import jetbrains.jetpass.core.threading.NamedThreadFactory;
import jetbrains.jetpass.core.throttling.KeyMapMaxSizeUpdateException;
import jetbrains.jetpass.core.throttling.LeakyBucketMap;
import jetbrains.jetpass.core.throttling.MaxSizeExceededException;
import jetbrains.jetpass.core.throttling.RateExceededException;
import jetbrains.jetpass.core.throttling.Scheduler;
import jetbrains.jetpass.core.throttling.StandardScheduler;
import jetbrains.jetpass.core.time.DurationExtKt;
import jetbrains.jetpass.core.time.Rate;
import jetbrains.jetpass.core.time.RateKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\f\b\u0016\u0018\u0000 D*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002DEBA\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u00020\u0006H\u0002J\u0013\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00028\u0000\u00a2\u0006\u0002\u00108J\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000:J\u0015\u0010;\u001a\u00020\u00062\u0006\u00107\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00108J\u001d\u0010<\u001a\u00020\u00062\u0006\u00107\u001a\u00028\u00002\b\b\u0002\u0010=\u001a\u00020\u0006\u00a2\u0006\u0002\u0010>J\u001d\u0010?\u001a\u00020\u00062\u0006\u00107\u001a\u00028\u00002\b\b\u0002\u0010=\u001a\u00020\u0006\u00a2\u0006\u0002\u0010>J\u0006\u0010@\u001a\u000203J\u0016\u0010A\u001a\u0002032\f\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010-H\u0002J0\u0010C\u001a\u0002032\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006H\u0002R$\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R$\u0010$\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010\u0013R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010.\u001a\u00020/8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011\u00a8\u0006F"}, d2={"Ljetbrains/jetpass/core/throttling/LeakyBucketMap;", "Key", "", "isLeaking", "", "maxSize", "", "leakRate", "Ljetbrains/jetpass/core/time/Rate;", "bucketSize", "scheduler", "Ljetbrains/jetpass/core/throttling/Scheduler;", "minRatePeriod", "Ljava/time/Duration;", "(ZILjetbrains/jetpass/core/time/Rate;ILjetbrains/jetpass/core/throttling/Scheduler;Ljava/time/Duration;)V", "value", "getBucketSize", "()I", "setBucketSize", "(I)V", "cooldownDelay", "", "getCooldownDelay", "()J", "innerSize", "Ljava/util/concurrent/atomic/AtomicInteger;", "()Z", "setLeaking", "(Z)V", "getLeakRate", "()Ljetbrains/jetpass/core/time/Rate;", "setLeakRate", "(Ljetbrains/jetpass/core/time/Rate;)V", "leakRateAmount", "getLeakRateAmount", "setLeakRateAmount", "leakRatePeriodSec", "getLeakRatePeriodSec", "setLeakRatePeriodSec", "(J)V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "getMaxSize", "setMaxSize", "periodicJobSchedule", "Ljava/util/concurrent/ScheduledFuture;", "settings", "Ljetbrains/jetpass/core/throttling/LeakyBucketMap$Settings;", "size", "getSize", "cancelPeriodicJob", "", "doPeriodicJob", "drainMap", "get", "key", "(Ljava/lang/Object;)I", "getFullBuckets", "", "increaseSizeOrThrow", "leak", "amount", "(Ljava/lang/Object;I)I", "pour", "resetSettings", "updateSchedule", "future", "updateSettings", "Companion", "Settings", "jetbrains.jetpass.core"})
public class LeakyBucketMap<Key> {
    private final ConcurrentHashMap<Key, Integer> map;
    private final AtomicInteger innerSize;
    private ScheduledFuture<?> periodicJobSchedule;
    private volatile Settings settings;
    private final Scheduler scheduler;
    private final Duration minRatePeriod;
    private static final Settings defaultSettings;
    public static final Companion Companion;

    public final boolean isLeaking() {
        return this.settings.isLeaking();
    }

    public final void setLeaking(boolean value) {
        LeakyBucketMap.updateSettings$default(this, value, 0, null, 0, 14, null);
    }

    public final int getMaxSize() {
        return this.settings.getMaxSize();
    }

    public final void setMaxSize(int value) {
        LeakyBucketMap.updateSettings$default(this, false, value, null, 0, 13, null);
    }

    public final int getSize() {
        return this.innerSize.get();
    }

    @NotNull
    public final Rate getLeakRate() {
        return this.settings.getLeakRate();
    }

    public final void setLeakRate(@NotNull Rate value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        LeakyBucketMap.updateSettings$default(this, false, 0, value, 0, 11, null);
    }

    public final int getLeakRateAmount() {
        return this.getLeakRate().getAmount();
    }

    public final void setLeakRateAmount(int value) {
        this.setLeakRate(RateKt.per(value, this.getLeakRate().getPeriod()));
    }

    public final long getLeakRatePeriodSec() {
        return this.getLeakRate().getPeriod().getSeconds();
    }

    public final void setLeakRatePeriodSec(long value) {
        int n = this.getLeakRate().getAmount();
        Duration duration = Duration.ofSeconds(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(value)");
        this.setLeakRate(RateKt.per(n, duration));
    }

    public final int getBucketSize() {
        return this.settings.getBucketSize();
    }

    public final void setBucketSize(int value) {
        LeakyBucketMap.updateSettings$default(this, false, 0, null, value, 7, null);
    }

    public final int pour(Key key, int amount) {
        int next;
        PreconditionsKt.requirePositiveOrZero(amount, "amount");
        if (amount == 0) {
            return this.get(key);
        }
        Settings settings = this.settings;
        while (true) {
            Integer current;
            Integer n;
            if ((n = (current = this.map.get(key))) == null) {
                n = 0;
            }
            next = n + amount;
            if (next > settings.getBucketSize()) {
                throw (Throwable)new RateExceededException(String.valueOf(key), settings.getLeakRate());
            }
            if (current == null) {
                this.increaseSizeOrThrow(key);
                if (this.map.putIfAbsent(key, next) == null) {
                    return next;
                }
                this.innerSize.decrementAndGet();
                continue;
            }
            if (this.map.replace(key, current, next)) break;
        }
        return next;
    }

    public static /* bridge */ /* synthetic */ int pour$default(LeakyBucketMap leakyBucketMap, Object object, int n, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pour");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return leakyBucketMap.pour(object, n);
    }

    public final int leak(Key key, int amount) {
        PreconditionsKt.requirePositiveOrZero(amount, "amount");
        if (amount == 0) {
            return this.get(key);
        }
        while (true) {
            Integer current;
            if (this.map.get(key) == null) {
                return 0;
            }
            int next = current - amount;
            if (next > 0) {
                if (!this.map.replace(key, current, next)) continue;
                return next;
            }
            if (this.map.remove(key, current)) break;
        }
        this.innerSize.decrementAndGet();
        return 0;
    }

    public static /* bridge */ /* synthetic */ int leak$default(LeakyBucketMap leakyBucketMap, Object object, int n, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: leak");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return leakyBucketMap.leak(object, n);
    }

    public final int get(Key key) {
        Integer n = this.map.get(key);
        return n != null ? n : 0;
    }

    private final void updateSettings(boolean isLeaking, int maxSize, Rate leakRate, int bucketSize) {
        Settings newSettings = new Settings(isLeaking, maxSize, leakRate, bucketSize);
        if (Intrinsics.areEqual((Object)newSettings, (Object)this.settings)) {
            return;
        }
        newSettings.validate(this.minRatePeriod);
        if (this.innerSize.get() > newSettings.getMaxSize()) {
            throw (Throwable)new KeyMapMaxSizeUpdateException(newSettings.getMaxSize(), this.innerSize.get());
        }
        if (this.settings.isLeaking() && !newSettings.isLeaking()) {
            this.cancelPeriodicJob();
        }
        boolean restartPeriodicJob = false;
        if (this.settings.isLeaking() && newSettings.isLeaking() && Intrinsics.areEqual((Object)this.settings.getLeakRate(), (Object)newSettings.getLeakRate()) ^ true) {
            this.cancelPeriodicJob();
            restartPeriodicJob = true;
        }
        restartPeriodicJob = restartPeriodicJob || !this.settings.isLeaking() && newSettings.isLeaking();
        this.settings = newSettings;
        if (restartPeriodicJob) {
            this.doPeriodicJob();
        }
    }

    static /* bridge */ /* synthetic */ void updateSettings$default(LeakyBucketMap leakyBucketMap, boolean bl, int n, Rate rate, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateSettings");
        }
        if ((n3 & 1) != 0) {
            bl = leakyBucketMap.settings.isLeaking();
        }
        if ((n3 & 2) != 0) {
            n = leakyBucketMap.settings.getMaxSize();
        }
        if ((n3 & 4) != 0) {
            rate = leakyBucketMap.settings.getLeakRate();
        }
        if ((n3 & 8) != 0) {
            n2 = leakyBucketMap.settings.getBucketSize();
        }
        leakyBucketMap.updateSettings(bl, n, rate, n2);
    }

    public final void resetSettings() {
        this.updateSettings(defaultSettings.isLeaking(), defaultSettings.getMaxSize(), defaultSettings.getLeakRate(), defaultSettings.getBucketSize());
    }

    public final long getCooldownDelay() {
        ScheduledFuture<?> scheduledFuture = this.periodicJobSchedule;
        Long l = scheduledFuture != null ? Long.valueOf(scheduledFuture.getDelay(TimeUnit.MILLISECONDS)) : null;
        Long it = l;
        return it == null || it < 0L ? this.settings.getLeakRate().getPeriod().toMillis() : it.longValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Key> getFullBuckets() {
        void var3_3;
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)this.map;
        Map destination$iv$iv = new LinkedHashMap();
        void var4_4 = $receiver$iv$iv;
        for (Map.Entry element$iv$iv : var4_4.entrySet()) {
            Map.Entry it = element$iv$iv;
            if (!(((Number)it.getValue()).intValue() >= this.settings.getBucketSize())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return var3_3.keySet();
    }

    private final int increaseSizeOrThrow(Key key) {
        Settings settings;
        Settings $receiver = settings = this.settings;
        int next = this.innerSize.incrementAndGet();
        if (next > $receiver.getMaxSize()) {
            this.innerSize.decrementAndGet();
            throw (Throwable)new MaxSizeExceededException(String.valueOf(key), $receiver.getMaxSize());
        }
        return next;
    }

    private final void doPeriodicJob() {
        Settings settings = this.settings;
        Settings $receiver = settings;
        if (!$receiver.isLeaking()) {
            this.cancelPeriodicJob();
            return;
        }
        this.drainMap();
        if ($receiver.isLeaking()) {
            ScheduledFuture<?> future = this.scheduler.schedule($receiver.getLeakRate().getPeriod(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ LeakyBucketMap this$0;
                {
                    this.this$0 = leakyBucketMap;
                    super(0);
                }

                public final void invoke() {
                    LeakyBucketMap.access$doPeriodicJob(this.this$0);
                }
            }));
            this.updateSchedule(future);
        } else {
            this.cancelPeriodicJob();
        }
    }

    private final synchronized void updateSchedule(ScheduledFuture<?> future) {
        this.periodicJobSchedule = future;
    }

    private final synchronized void cancelPeriodicJob() {
        ScheduledFuture<?> scheduledFuture;
        ScheduledFuture<?> it;
        ScheduledFuture<?> scheduledFuture2 = this.periodicJobSchedule;
        if (scheduledFuture2 != null && !(it = (scheduledFuture = scheduledFuture2)).isDone()) {
            try {
                it.cancel(false);
            }
            catch (Exception ex) {
                Companion.getLogger().warn((Throwable)ex, (Function0)cancelPeriodicJob.1.1.INSTANCE);
            }
        }
        this.periodicJobSchedule = null;
    }

    private final int drainMap() {
        Enumeration<Key> enumeration = this.map.keys();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"map.keys()");
        Enumeration<Key> enumeration2 = enumeration;
        ArrayList<Key> arrayList = Collections.list(enumeration2);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
        Iterable $receiver$iv = arrayList;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object key = element$iv = iterator2.next();
            this.leak(key, this.settings.getLeakRate().getAmount());
        }
        return this.innerSize.get();
    }

    public LeakyBucketMap(boolean isLeaking, int maxSize, @NotNull Rate leakRate, int bucketSize, @NotNull Scheduler scheduler, @NotNull Duration minRatePeriod) {
        Intrinsics.checkParameterIsNotNull((Object)leakRate, (String)"leakRate");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        Intrinsics.checkParameterIsNotNull((Object)minRatePeriod, (String)"minRatePeriod");
        this.scheduler = scheduler;
        this.minRatePeriod = minRatePeriod;
        this.map = new ConcurrentHashMap();
        this.innerSize = new AtomicInteger();
        this.settings = new Settings(isLeaking, maxSize, leakRate, bucketSize);
        this.settings.validate(this.minRatePeriod);
        if (this.settings.isLeaking()) {
            this.doPeriodicJob();
        }
    }

    public /* synthetic */ LeakyBucketMap(boolean bl, int n, Rate rate, int n2, Scheduler scheduler, Duration duration, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = defaultSettings.isLeaking();
        }
        if ((n3 & 2) != 0) {
            n = defaultSettings.getMaxSize();
        }
        if ((n3 & 4) != 0) {
            rate = defaultSettings.getLeakRate();
        }
        if ((n3 & 8) != 0) {
            n2 = defaultSettings.getBucketSize();
        }
        if ((n3 & 0x10) != 0) {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new NamedThreadFactory("leaky-map-pool", false, 2, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newScheduledTh\u2026actory(\"leaky-map-pool\"))");
            scheduler = new StandardScheduler(scheduledExecutorService);
        }
        if ((n3 & 0x20) != 0) {
            duration = DurationExtKt.getSecond(1);
        }
        this(bl, n, rate, n2, scheduler, duration);
    }

    public LeakyBucketMap() {
        this(false, 0, null, 0, null, null, 63, null);
    }

    static {
        Companion = new Companion(null);
        defaultSettings = new Settings(false, 10000, RateKt.per(3, DurationExtKt.getHours(6)), 3);
    }

    public static final /* synthetic */ void access$doPeriodicJob(LeakyBucketMap $this) {
        $this.doPeriodicJob();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/core/throttling/LeakyBucketMap$Settings;", "", "isLeaking", "", "maxSize", "", "leakRate", "Ljetbrains/jetpass/core/time/Rate;", "bucketSize", "(ZILjetbrains/jetpass/core/time/Rate;I)V", "getBucketSize", "()I", "()Z", "getLeakRate", "()Ljetbrains/jetpass/core/time/Rate;", "getMaxSize", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "validate", "", "minRatePeriod", "Ljava/time/Duration;", "jetbrains.jetpass.core"})
    private static final class Settings {
        private final boolean isLeaking;
        private final int maxSize;
        @NotNull
        private final Rate leakRate;
        private final int bucketSize;

        public final void validate(@NotNull Duration minRatePeriod) {
            Intrinsics.checkParameterIsNotNull((Object)minRatePeriod, (String)"minRatePeriod");
            PreconditionsKt.requirePositive(this.maxSize, "maxSize");
            PreconditionsKt.requirePositive(this.bucketSize, "maxValuePerKey");
            PreconditionsKt.requireArgument$default(this.leakRate.getPeriod(), null, "Leaking rate period should be greater or equal to " + minRatePeriod, (Function1)new Function1<Duration, Boolean>(minRatePeriod){
                final /* synthetic */ Duration $minRatePeriod;

                public final boolean invoke(@NotNull Duration it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.toMillis() >= this.$minRatePeriod.toMillis();
                }
                {
                    this.$minRatePeriod = duration;
                    super(1);
                }
            }, 2, null);
        }

        public final boolean isLeaking() {
            return this.isLeaking;
        }

        public final int getMaxSize() {
            return this.maxSize;
        }

        @NotNull
        public final Rate getLeakRate() {
            return this.leakRate;
        }

        public final int getBucketSize() {
            return this.bucketSize;
        }

        public Settings(boolean isLeaking, int maxSize, @NotNull Rate leakRate, int bucketSize) {
            Intrinsics.checkParameterIsNotNull((Object)leakRate, (String)"leakRate");
            this.isLeaking = isLeaking;
            this.maxSize = maxSize;
            this.leakRate = leakRate;
            this.bucketSize = bucketSize;
        }

        public final boolean component1() {
            return this.isLeaking;
        }

        public final int component2() {
            return this.maxSize;
        }

        @NotNull
        public final Rate component3() {
            return this.leakRate;
        }

        public final int component4() {
            return this.bucketSize;
        }

        @NotNull
        public final Settings copy(boolean isLeaking, int maxSize, @NotNull Rate leakRate, int bucketSize) {
            Intrinsics.checkParameterIsNotNull((Object)leakRate, (String)"leakRate");
            return new Settings(isLeaking, maxSize, leakRate, bucketSize);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Settings copy$default(Settings settings, boolean bl, int n, Rate rate, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = settings.isLeaking;
            }
            if ((n3 & 2) != 0) {
                n = settings.maxSize;
            }
            if ((n3 & 4) != 0) {
                rate = settings.leakRate;
            }
            if ((n3 & 8) != 0) {
                n2 = settings.bucketSize;
            }
            return settings.copy(bl, n, rate, n2);
        }

        public String toString() {
            return "Settings(isLeaking=" + this.isLeaking + ", maxSize=" + this.maxSize + ", leakRate=" + this.leakRate + ", bucketSize=" + this.bucketSize + ")";
        }

        public int hashCode() {
            int n = this.isLeaking ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Rate rate = this.leakRate;
            return ((n * 31 + Integer.hashCode(this.maxSize)) * 31 + (rate != null ? ((Object)rate).hashCode() : 0)) * 31 + Integer.hashCode(this.bucketSize);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (!(this.isLeaking == settings.isLeaking) || !(this.maxSize == settings.maxSize) || !Intrinsics.areEqual((Object)this.leakRate, (Object)settings.leakRate) || !(this.bucketSize == settings.bucketSize)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/core/throttling/LeakyBucketMap$Companion;", "Lmu/KLogging;", "()V", "defaultSettings", "Ljetbrains/jetpass/core/throttling/LeakyBucketMap$Settings;", "jetbrains.jetpass.core"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

