/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.core.throttling;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.jetpass.core.throttling.LeakyBucketMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001#B+\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ7\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0001\u0010\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u001c0 \u00a2\u0006\u0002\u0010\"R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006$"}, d2={"Ljetbrains/jetpass/core/throttling/RateLimiter;", "Key", "", "isEnabled", "", "failedKeys", "Ljetbrains/jetpass/core/throttling/LeakyBucketMap;", "blackListedIPs", "", "", "(ZLjetbrains/jetpass/core/throttling/LeakyBucketMap;Ljava/util/Set;)V", "_enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getBlackListedIPs", "()Ljava/util/Set;", "blockedUsernames", "", "getBlockedUsernames", "()Ljava/lang/Iterable;", "getFailedKeys", "()Ljetbrains/jetpass/core/throttling/LeakyBucketMap;", "value", "()Z", "setEnabled", "(Z)V", "whiteList", "getWhiteList", "execute", "T", "key", "ignoreFailure", "action", "Lkotlin/Function1;", "Ljetbrains/jetpass/core/throttling/RateLimiter$LimiterSession;", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "LimiterSession", "jetbrains.jetpass.core"})
public class RateLimiter<Key> {
    private final AtomicBoolean _enabled;
    @NotNull
    private final Set<Key> whiteList;
    @NotNull
    private final LeakyBucketMap<Key> failedKeys;
    @NotNull
    private final Set<String> blackListedIPs;

    public final boolean isEnabled() {
        return this._enabled.get();
    }

    public final void setEnabled(boolean value) {
        if (this._enabled.getAndSet(value) != value) {
            this.failedKeys.setLeaking(value);
        }
    }

    @NotNull
    public final Set<Key> getWhiteList() {
        return this.whiteList;
    }

    @NotNull
    public final Iterable<Key> getBlockedUsernames() {
        return SetsKt.minus(this.failedKeys.getFullBuckets(), (Iterable)this.whiteList);
    }

    public final <T> T execute(@NotNull Key key, boolean ignoreFailure, @NotNull Function1<? super LimiterSession, ? extends T> action) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        LimiterSession session = new LimiterSession();
        if (!this.isEnabled() || this.whiteList.contains(key) || ignoreFailure) {
            return (T)action.invoke((Object)session);
        }
        LeakyBucketMap.pour$default(this.failedKeys, key, 0, 2, null);
        Object result = action.invoke((Object)session);
        if (session.getSuccess()) {
            LeakyBucketMap.leak$default(this.failedKeys, key, 0, 2, null);
        }
        return (T)result;
    }

    public static /* bridge */ /* synthetic */ Object execute$default(RateLimiter rateLimiter, Object object, boolean bl, Function1 function1, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execute");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return rateLimiter.execute(object, bl, function1);
    }

    @NotNull
    public final LeakyBucketMap<Key> getFailedKeys() {
        return this.failedKeys;
    }

    @NotNull
    public final Set<String> getBlackListedIPs() {
        return this.blackListedIPs;
    }

    public RateLimiter(boolean isEnabled, @NotNull LeakyBucketMap<Key> failedKeys, @NotNull Set<String> blackListedIPs) {
        Intrinsics.checkParameterIsNotNull(failedKeys, (String)"failedKeys");
        Intrinsics.checkParameterIsNotNull(blackListedIPs, (String)"blackListedIPs");
        this.failedKeys = failedKeys;
        this.blackListedIPs = blackListedIPs;
        this._enabled = new AtomicBoolean(isEnabled);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkExpressionValueIsNotNull(keySetView, (String)"ConcurrentHashMap.newKeySet<Key>()");
        this.whiteList = keySetView;
    }

    public /* synthetic */ RateLimiter(boolean bl, LeakyBucketMap leakyBucketMap, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, leakyBucketMap, set);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/core/throttling/RateLimiter$LimiterSession;", "", "()V", "<set-?>", "", "success", "getSuccess", "()Z", "setSuccess", "(Z)V", "dontLimit", "", "jetbrains.jetpass.core"})
    public static final class LimiterSession {
        private boolean success;

        public final boolean getSuccess() {
            return this.success;
        }

        private final void setSuccess(boolean bl) {
            this.success = bl;
        }

        public final void dontLimit() {
            this.success = true;
        }
    }
}

