/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();
    private volatile int numWaiters = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence = cursor.get();
        if (availableSequence < sequence) {
            this.lock.lock();
            try {
                ++this.numWaiters;
                while ((availableSequence = cursor.get()) < sequence) {
                    barrier.checkAlert();
                    this.processorNotifyCondition.await(1L, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                --this.numWaiters;
                this.lock.unlock();
            }
        }
        if (0 != dependents.length) {
            while ((availableSequence = Util.getMinimumSequence(dependents)) < sequence) {
                barrier.checkAlert();
            }
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier, long timeout, TimeUnit sourceUnit) throws AlertException, InterruptedException {
        long availableSequence = cursor.get();
        if (availableSequence < sequence) {
            this.lock.lock();
            try {
                ++this.numWaiters;
                while ((availableSequence = cursor.get()) < sequence) {
                    barrier.checkAlert();
                    if (this.processorNotifyCondition.await(timeout, sourceUnit)) continue;
                    break;
                }
            }
            finally {
                --this.numWaiters;
                this.lock.unlock();
            }
        }
        if (0 != dependents.length) {
            while ((availableSequence = Util.getMinimumSequence(dependents)) < sequence) {
                barrier.checkAlert();
            }
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        if (0 != this.numWaiters) {
            this.lock.lock();
            try {
                this.processorNotifyCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

