/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.youtrack.reports.impl.XdReport;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0007H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001e\u0010\u0015\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001f\u0010\u0016\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0007\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u00020\r\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0019\u001a\u0002H\u000bH\u0002\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00072\u0006\u0010\u001c\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/reports/ReportsDataMapper;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "logInfo", "", "Ljetbrains/youtrack/reports/impl/XdReport;", "getLogInfo", "(Ljetbrains/youtrack/reports/impl/XdReport;)Ljava/lang/String;", "deserializeJson", "T", "blob", "Ljava/io/InputStream;", "report", "(Ljava/io/InputStream;Ljetbrains/youtrack/reports/impl/XdReport;)Ljava/lang/Object;", "handleReadException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleWriteException", "read", "(Ljetbrains/youtrack/reports/impl/XdReport;)Ljava/lang/Object;", "serializeJson", "json", "(Ljava/lang/Object;)Ljava/io/InputStream;", "write", "data", "(Ljetbrains/youtrack/reports/impl/XdReport;Ljava/lang/Object;)V", "Companion", "youtrack-reports"})
public final class ReportsDataMapper {
    private final ObjectMapper mapper;
    public static final Companion Companion = new Companion(null);

    public final <T> T read(@NotNull XdReport<? extends T> report2) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        InputStream inputStream = report2.getData();
        if (inputStream == null) {
            throw (Throwable)new IllegalStateException("Trial to read report with null data in state " + report2.getState().getEntityId());
        }
        InputStream data = inputStream;
        return this.deserializeJson(data, report2);
    }

    public final <T> void write(@NotNull XdReport<? extends T> report2, T data) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        report2.setData(this.serializeJson(data));
    }

    public final void handleReadException(@NotNull Exception e, @NotNull XdReport<?> report2) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        Exception exception = e;
        if (exception instanceof IllegalStateException) {
            Companion.getLogger().warn((Function0)new Function0<String>(this, report2, e){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to deserialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + ": " + this.$e.getMessage();
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    this.$e = exception;
                    super(0);
                }
            });
        } else if (exception instanceof JsonProcessingException) {
            Companion.getLogger().info((Function0)new Function0<String>(this, report2, e){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to deserialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + " data due to obsolete data json structure: " + this.$e.getMessage();
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    this.$e = exception;
                    super(0);
                }
            });
        } else if (exception instanceof ClassNotFoundException) {
            Companion.getLogger().info((Function0)new Function0<String>(this, report2, e){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to deserialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + " data due to obsolete data classes: " + this.$e.getMessage();
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    this.$e = exception;
                    super(0);
                }
            });
        } else {
            Companion.getLogger().warn((Function0)new Function0<String>(this, report2, e){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;
                final /* synthetic */ Exception $e;

                @NotNull
                public final String invoke() {
                    return "Failed to deserialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + " data due to exception: " + this.$e.getMessage();
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    this.$e = exception;
                    super(0);
                }
            });
        }
    }

    public final void handleWriteException(@NotNull Exception e, @NotNull XdReport<?> report2) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        Exception exception = e;
        if (exception instanceof IOException) {
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(this, report2){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;

                @NotNull
                public final String invoke() {
                    return "Failed to serialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + " data due to I/O exception";
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    super(0);
                }
            });
        } else if (exception instanceof ReadonlyTransactionException) {
            Companion.getLogger().info((Function0)new Function0<String>(this, report2){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;

                @NotNull
                public final String invoke() {
                    return "Failed to serialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + " data due database is in read-only mode";
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    super(0);
                }
            });
        } else {
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(this, report2){
                final /* synthetic */ ReportsDataMapper this$0;
                final /* synthetic */ XdReport $report;

                @NotNull
                public final String invoke() {
                    return "Failed to serialize report " + ReportsDataMapper.access$getLogInfo$p(this.this$0, this.$report) + " data due to exception";
                }
                {
                    this.this$0 = reportsDataMapper;
                    this.$report = xdReport2;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> InputStream serializeJson(T json) {
        byte[] byArray;
        String content = this.mapper.writeValueAsString(json);
        Closeable closeable = new ByteArrayOutputStream(content.length());
        Throwable throwable = null;
        try {
            ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPOutputStream(out);
            Throwable throwable2 = null;
            try {
                GZIPOutputStream gzip = (GZIPOutputStream)closeable2;
                boolean bl2 = false;
                String string = content;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                String string2 = string;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                GZIPOutputStream gZIPOutputStream = gzip;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string3.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray2;
                gZIPOutputStream.write(byArray3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] gzipped = byArray;
        return new ByteArrayInputStream(gzipped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T deserializeJson(InputStream blob, XdReport<? extends T> report2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Closeable closeable = new GZIPInputStream(blob);
        Throwable throwable = null;
        try {
            GZIPInputStream it = (GZIPInputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)out, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String content = out.toString(StandardCharsets.UTF_8.name());
        return (T)this.mapper.readValue(content, report2.getDataType());
    }

    private final String getLogInfo(@NotNull XdReport<?> $receiver) {
        return "" + '[' + $receiver.getEntityId() + ':' + $receiver.getEntity().getType() + ':' + $receiver.getOwner().getEntityId() + ']';
    }

    public ReportsDataMapper() {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new KotlinModule(0, 1, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n         \u2026terModule(KotlinModule())");
        this.mapper = objectMapper;
    }

    public static final /* synthetic */ String access$getLogInfo$p(ReportsDataMapper $this, XdReport $receiver) {
        return $this.getLogInfo($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/reports/ReportsDataMapper$Companion;", "Lmu/KLogging;", "()V", "youtrack-reports"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

