/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports;

import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.parser.BeansKt;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.searchRequest.ParseErrorException;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.RequestBuilder;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.reports.ReportsDataMapper;
import jetbrains.youtrack.reports.ReportsService;
import jetbrains.youtrack.reports.impl.RangeReport;
import jetbrains.youtrack.reports.impl.XdAbstractTimeRange;
import jetbrains.youtrack.reports.impl.XdReport;
import jetbrains.youtrack.reports.impl.XdReportState;
import jetbrains.youtrack.reports.impl.distribution.flat.XdFlatDistributionReport;
import jetbrains.youtrack.reports.impl.distribution.matrix.XdMatrixReport;
import jetbrains.youtrack.reports.impl.elka.XdElkaReport;
import jetbrains.youtrack.reports.impl.history.rate.XdRateReport;
import jetbrains.youtrack.reports.impl.time.simple.XdTimeReport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007J8\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000eJ\u0012\u0010\u0016\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u0017\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u0018\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0007J+\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a\"\u000e\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001a0\u00072\u0006\u0010\f\u001a\u0002H\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/reports/ReportsService;", "", "()V", "reportsDataMapper", "Ljetbrains/youtrack/reports/ReportsDataMapper;", "accessibleReports", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/reports/impl/XdReport;", "user", "Ljetbrains/youtrack/persistent/XdUser;", "error", "", "report", "isOutdated", "", "issuesOf", "Ljetbrains/youtrack/persistent/XdIssue;", "parseResult", "Ljetbrains/charisma/smartui/parser/search/IParseResult;", "context", "Ljetbrains/charisma/smartui/persistent/Context;", "sorted", "ready", "reset", "resetAndTriggerCalculation", "tryGetData", "T", "W", "(Ljetbrains/youtrack/reports/impl/XdReport;)Ljava/lang/Object;", "afterCalculate", "afterError", "youtrack-reports"})
public final class ReportsService {
    @Autowired
    private ReportsDataMapper reportsDataMapper;

    @NotNull
    public final XdQuery<XdReport<Object>> accessibleReports(@NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        XdQuery notOwn2 = XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdReport.Companion), (Function2)((Function2)new Function2<FilteringContext, XdReport<? extends Object>, XdSearchingNode>(user){
            final /* synthetic */ XdUser $user;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdReport<? extends Object> it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return $receiver.ne((XdEntity)it.getOwner(), (XdEntity)this.$user);
            }
            {
                this.$user = xdUser;
                super(2);
            }
        }));
        XdQuery result2 = XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdReport.Companion), (Function2)accessibleReports.result.1.INSTANCE);
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)user.getUserGroupsExcludingAllUserGroups());
        for (Object element$iv : $receiver$iv) {
            XdUserGroup group = (XdUserGroup)element$iv;
            boolean bl = false;
            result2 = XdQueryKt.union((XdQuery)result2, (XdQuery)XdFilteringQueryKt.filter((XdQuery)notOwn2, (Function2)((Function2)new Function2<FilteringContext, XdReport<? extends Object>, XdSearchingNode>(group){
                final /* synthetic */ XdUserGroup $group;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdReport<? extends Object> it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return $receiver.eq((XdEntity)it.getVisibleTo(), (XdEntity)this.$group);
                }
                {
                    this.$group = xdUserGroup;
                    super(2);
                }
            })));
        }
        result2 = XdQueryKt.union((XdQuery)result2, (XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdReport.Companion), (Function2)((Function2)new Function2<FilteringContext, XdReport<? extends Object>, XdSearchingNode>(user){
            final /* synthetic */ XdUser $user;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdReport<? extends Object> it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return $receiver.eq((XdEntity)it.getOwner(), (XdEntity)this.$user);
            }
            {
                this.$user = xdUser;
                super(2);
            }
        })));
        return XdFilteringQueryKt.filter((XdQuery)result2, (Function2)accessibleReports.3.INSTANCE);
    }

    @NotNull
    public static /* synthetic */ XdQuery accessibleReports$default(ReportsService reportsService, XdUser xdUser, int n, Object object) {
        if ((n & 1) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return reportsService.accessibleReports(xdUser);
    }

    public final void error(@NotNull XdReport<?> report2) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        XdReportState xdReportState = report2.getState();
        if (Intrinsics.areEqual((Object)((Object)xdReportState), (Object)((Object)XdReportState.Companion.getCALCULATING()))) {
            report2.setState(XdReportState.Companion.getERROR());
            this.afterError(report2);
            this.afterCalculate(report2);
        } else if (Intrinsics.areEqual((Object)((Object)xdReportState), (Object)((Object)XdReportState.Companion.getREADY()))) {
            report2.setState(XdReportState.Companion.getCALCULATING());
        }
    }

    public final void ready(@NotNull XdReport<?> report2) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        XdReportState xdReportState = report2.getState();
        if (Intrinsics.areEqual((Object)((Object)xdReportState), (Object)((Object)XdReportState.Companion.getCALCULATING()))) {
            report2.setState(XdReportState.Companion.getREADY());
            this.afterCalculate(report2);
        }
    }

    public final void reset(@NotNull XdReport<?> report2) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        XdReportState xdReportState = report2.getState();
        if (Intrinsics.areEqual((Object)((Object)xdReportState), (Object)((Object)XdReportState.Companion.getERROR()))) {
            report2.clearError();
            report2.setState(XdReportState.Companion.getCALCULATING());
        } else if (Intrinsics.areEqual((Object)((Object)xdReportState), (Object)((Object)XdReportState.Companion.getREADY()))) {
            report2.setState(XdReportState.Companion.getCALCULATING());
        }
    }

    private final void afterCalculate(@NotNull XdReport<?> $receiver) {
        $receiver.setLastCalculated(System.currentTimeMillis());
        $receiver.setRequiresRecalculation(false);
    }

    private final void afterError(@NotNull XdReport<?> $receiver) {
        if ($receiver.getError() == null) {
            throw (Throwable)new IllegalArgumentException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("Report.State.machine.Exception_type_was_not_specified", new Object[0]));
        }
    }

    @Nullable
    public final <T, W extends XdReport<? extends T>> T tryGetData(@NotNull W report2) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        T result2 = null;
        boolean outdated = this.isOutdated(report2);
        if (outdated && Intrinsics.areEqual((Object)((Object)report2.getState()), (Object)((Object)XdReportState.Companion.getCALCULATING())) ^ true) {
            this.resetAndTriggerCalculation(report2);
        } else if (!outdated && Intrinsics.areEqual((Object)((Object)report2.getState()), (Object)((Object)XdReportState.Companion.getREADY()))) {
            try {
                ReportsDataMapper reportsDataMapper = this.reportsDataMapper;
                if (reportsDataMapper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"reportsDataMapper");
                }
                result2 = reportsDataMapper.read(report2);
            }
            catch (Exception e) {
                ReportsDataMapper reportsDataMapper = this.reportsDataMapper;
                if (reportsDataMapper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"reportsDataMapper");
                }
                reportsDataMapper.handleReadException(e, report2);
                this.resetAndTriggerCalculation(report2);
            }
        }
        return result2;
    }

    public final void resetAndTriggerCalculation(@NotNull XdReport<?> report2) {
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        report2.setData(null);
        report2.setLastCalculated(null);
        this.reset(report2);
        LegacySupportKt.flush();
    }

    @NotNull
    public final XdQuery<XdIssue> issuesOf(@NotNull XdReport<?> report2, @Nullable IParseResult parseResult, @NotNull Context context2, boolean sorted) {
        Iterable iterable;
        IParseResult result2;
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        IParseResult iParseResult = parseResult;
        if (iParseResult == null) {
            iParseResult = jetbrains.charisma.persistent.BeansKt.getParser().parse(report2.getProjects().getEntityIterable(), report2.getQuery(), (IContext)context2);
        }
        IParseResult iParseResult2 = result2 = iParseResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)iParseResult2, (String)"result");
        Iterable it = iterable = iParseResult2.getSyntaxErrors();
        boolean bl = false;
        if (CollectionUtilKt.isNotEmpty((Iterable)it)) {
            Iterable iterable2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"it");
            throw (Throwable)new ParseErrorException(CollectionsKt.toList((Iterable)iterable2), context2, "Report.query", "Can't parse report query");
        }
        RequestBuilder builder = BeansKt.getRequestBuilderFactory().newRequestBuilder(result2, (IContext)context2).me(report2.getOwner().getEntity()).secure();
        if (sorted && !BeansKt.getParseResultUtil().canBeSortedByRelevance(report2.getOwner().getEntity(), result2, null)) {
            builder = builder.sort();
        }
        return XdQueryKt.asQuery((Iterable)builder.issues(), (XdEntityType)((XdEntityType)XdIssue.Companion));
    }

    @NotNull
    public static /* synthetic */ XdQuery issuesOf$default(ReportsService reportsService, XdReport xdReport2, IParseResult iParseResult, Context context2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            iParseResult = null;
        }
        if ((n & 4) != 0) {
            context2 = new Context();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return reportsService.issuesOf(xdReport2, iParseResult, context2, bl);
    }

    public final boolean isOutdated(@NotNull XdReport<?> report2) {
        boolean bl;
        boolean fast;
        Object object;
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        Long l = report2.getLastCalculated();
        if (l == null) {
            return false;
        }
        long lastCalculation = l;
        if (report2.getRequiresRecalculation()) {
            return true;
        }
        long now = System.currentTimeMillis();
        XdReport<?> xdReport2 = report2;
        if (!(xdReport2 instanceof RangeReport)) {
            xdReport2 = null;
        }
        if ((object = (RangeReport)((Object)xdReport2)) != null && (object = object.findRange()) != null) {
            Object object2;
            Object range2 = object2 = object;
            boolean bl2 = false;
            Long to = ((XdAbstractTimeRange)range2).getRange(now).getTo();
            if (to < now && to < lastCalculation) {
                return false;
            }
        }
        long interval = now - lastCalculation;
        XdReport<?> xdReport3 = report2;
        boolean bl3 = xdReport3 instanceof XdElkaReport ? true : (xdReport3 instanceof XdFlatDistributionReport ? true : (xdReport3 instanceof XdRateReport ? true : (xdReport3 instanceof XdMatrixReport ? true : (fast = xdReport3 instanceof XdTimeReport))));
        if (fast) {
            bl = interval > (long)600000;
        } else {
            long l2;
            long it = l2 = report2.getInvalidationInterval();
            boolean bl4 = false;
            bl = it != 0L && it != -1L && interval > it;
        }
        return bl;
    }
}

