/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.agile;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.smartui.parser.date.DatePeriod;
import jetbrains.charisma.smartui.parser.date.RangeDatePeriod;
import jetbrains.youtrack.agile.persistence.SprintIssuesUtilKt;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.core.dates.DateMath;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserKt;
import jetbrains.youtrack.reports.impl.agile.AgileReportsKt;
import jetbrains.youtrack.reports.impl.agile.XdAgileReportSettingsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/reports/impl/agile/XdSprintBasedReport;", "", "effectiveQuery", "", "getEffectiveQuery", "()Ljava/lang/String;", "issuesQuery", "getIssuesQuery", "sprint", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "getSprint", "()Ljetbrains/youtrack/agile/persistence/XdSprint;", "sprintLength", "Lorg/joda/time/Period;", "getSprintLength", "()Lorg/joda/time/Period;", "canReadThis", "", "user", "Ljetbrains/youtrack/persistent/XdUser;", "datePeriod", "Ljetbrains/charisma/smartui/parser/date/DatePeriod;", "now", "", "getIssues", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/persistent/XdIssue;", "youtrack-reports"})
public interface XdSprintBasedReport {
    @NotNull
    public Period getSprintLength();

    @NotNull
    public XdSprint getSprint();

    @Nullable
    public String getIssuesQuery();

    @Nullable
    public String getEffectiveQuery();

    @NotNull
    public XdQuery<XdIssue> getIssues();

    @NotNull
    public DatePeriod datePeriod(long var1);

    public boolean canReadThis(@NotNull XdUser var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Period getSprintLength(XdSprintBasedReport $this) {
            Period period = Period.weeks((int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.weeks(2)");
            return period;
        }

        @Nullable
        public static String getIssuesQuery(XdSprintBasedReport $this) {
            return XdAgileReportSettingsKt.getReportSettings($this.getSprint().getAgile()).getIssuesQuery();
        }

        @Nullable
        public static String getEffectiveQuery(XdSprintBasedReport $this) {
            return AgileReportsKt.getSprintBasedQuery($this.getSprint(), $this.getIssuesQuery());
        }

        @NotNull
        public static XdQuery<XdIssue> getIssues(XdSprintBasedReport $this) {
            return AgileReportsKt.filterCardSubtasks((XdQuery<? extends XdIssue>)SprintIssuesUtilKt.getReportedIssues$default((XdSprint)$this.getSprint(), (String)$this.getIssuesQuery(), (boolean)false, (boolean)false, (int)6, null), $this.getSprint());
        }

        @NotNull
        public static DatePeriod datePeriod(XdSprintBasedReport $this, long now) {
            DateTimeZone ownerZone = XdUserKt.timezone((XdUser)$this.getSprint().getAgile().getOwner());
            Long sprintStartInUTC = $this.getSprint().getStart();
            Long sprintFinishInUTC = $this.getSprint().getFinish();
            Long startInOwnerZone = null;
            Long finishInOwnerZone = null;
            if (sprintStartInUTC == null && sprintFinishInUTC == null) {
                DateTime dateTime = new DateTime(now).minus((ReadablePeriod)$this.getSprintLength());
                Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"(DateTime(now) - sprintLength)");
                startInOwnerZone = DateMath.getDateFinishInTimezone((Long)dateTime.getMillis(), (DateTimeZone)ownerZone) + 1L;
                finishInOwnerZone = DateMath.getDateFinishInTimezone((Long)now, (DateTimeZone)ownerZone);
            } else {
                startInOwnerZone = DateMath.shiftTimeToZone((Long)sprintStartInUTC, (DateTimeZone)DateTimeZone.UTC, (DateTimeZone)ownerZone);
                finishInOwnerZone = DateMath.shiftTimeToZone((Long)sprintFinishInUTC, (DateTimeZone)DateTimeZone.UTC, (DateTimeZone)ownerZone);
            }
            return (DatePeriod)new RangeDatePeriod(startInOwnerZone, finishInOwnerZone);
        }

        public static boolean canReadThis(XdSprintBasedReport $this, @NotNull XdUser user) {
            Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
            return $this.getSprint().getAgile().isAccessible(Operation.READ, user);
        }

        public static /* synthetic */ boolean canReadThis$default(XdSprintBasedReport xdSprintBasedReport, XdUser xdUser, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canReadThis");
            }
            if ((n & 1) != 0) {
                xdUser = BeansKt.getXdLoggedInUser();
            }
            return xdSprintBasedReport.canReadThis(xdUser);
        }
    }
}

