/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.gantt;

import java.util.List;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.reports.ReportCalculationMonitor;
import jetbrains.youtrack.reports.ReportDataCalculator;
import jetbrains.youtrack.reports.impl.gantt.GanttReportDataBlobBuilder;
import jetbrains.youtrack.reports.impl.gantt.GanttReportDataJson;
import jetbrains.youtrack.reports.impl.gantt.GanttReportRawTasksBuilder;
import jetbrains.youtrack.reports.impl.gantt.GanttReportTopLevelIssuesSelector;
import jetbrains.youtrack.reports.impl.gantt.GanttTopLevelTasksSorter;
import jetbrains.youtrack.reports.impl.gantt.MemoryTask;
import jetbrains.youtrack.reports.impl.gantt.ReportLinkNameResolver;
import jetbrains.youtrack.reports.impl.gantt.XdCapacityConfig;
import jetbrains.youtrack.reports.impl.gantt.XdGanttReport;
import jetbrains.youtrack.reports.impl.gantt.XdMaxWorkInProgressCapacityConfig;
import jetbrains.youtrack.reports.impl.gantt.algorithm.AssigneeBasedCapacityGanttReportAlgorithm;
import jetbrains.youtrack.reports.impl.gantt.algorithm.GanttReportAlgorithm;
import jetbrains.youtrack.reports.impl.gantt.algorithm.InfiniteCapacityGanttReportAlgorithm;
import jetbrains.youtrack.reports.impl.gantt.algorithm.MaxWIPCapacityGanttReportAlgorithm;
import jetbrains.youtrack.reports.impl.gantt.algorithm.TimeOptimizingGanttReportAlgorithm;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/reports/impl/gantt/GanttDataCalculator;", "Ljetbrains/youtrack/reports/ReportDataCalculator;", "Ljetbrains/youtrack/reports/impl/gantt/GanttReportDataJson;", "Ljetbrains/youtrack/reports/impl/gantt/XdGanttReport;", "()V", "suitableReportTypes", "", "Ljetbrains/youtrack/reports/impl/gantt/XdGanttReport$Companion;", "getSuitableReportTypes", "()Ljava/util/List;", "calculate", "report", "monitor", "Ljetbrains/youtrack/reports/ReportCalculationMonitor;", "youtrack-reports"})
public final class GanttDataCalculator
implements ReportDataCalculator<GanttReportDataJson, XdGanttReport> {
    @NotNull
    private final List<XdGanttReport.Companion> suitableReportTypes = CollectionsKt.listOf((Object)((Object)XdGanttReport.Companion));

    @Override
    @NotNull
    public List<XdGanttReport.Companion> getSuitableReportTypes() {
        return this.suitableReportTypes;
    }

    @Override
    @NotNull
    public GanttReportDataJson calculate(@NotNull XdGanttReport report2, @NotNull ReportCalculationMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)report2), (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        XdQuery<XdIssue> topLevelIssues = GanttReportTopLevelIssuesSelector.INSTANCE.select(report2);
        GanttReportRawTasksBuilder rawTasksBuilder = new GanttReportRawTasksBuilder(report2);
        Iterable $receiver$iv = XdQueryKt.asIterable(topLevelIssues);
        for (Object element$iv : $receiver$iv) {
            XdIssue it = (XdIssue)element$iv;
            boolean bl = false;
            rawTasksBuilder.addIssue(it);
        }
        List<MemoryTask<XdIssue, XdUser>> rawTasks = rawTasksBuilder.build();
        GanttReportAlgorithm algorithm = null;
        ReportLinkNameResolver resolver = new ReportLinkNameResolver(report2);
        XdCapacityConfig capacityConfig2 = report2.getCapacityConfig();
        algorithm = capacityConfig2 instanceof XdMaxWorkInProgressCapacityConfig ? (((XdMaxWorkInProgressCapacityConfig)capacityConfig2).getSortProperty() == null ? (GanttReportAlgorithm)new TimeOptimizingGanttReportAlgorithm(resolver, ((XdMaxWorkInProgressCapacityConfig)capacityConfig2).getMaxWorkInProgress()) : (GanttReportAlgorithm)new MaxWIPCapacityGanttReportAlgorithm(resolver, ((XdMaxWorkInProgressCapacityConfig)capacityConfig2).getMaxWorkInProgress())) : (capacityConfig2.getAssigneeField() == null && report2.getStartDateField() == null ? (GanttReportAlgorithm)new InfiniteCapacityGanttReportAlgorithm(resolver) : (GanttReportAlgorithm)new AssigneeBasedCapacityGanttReportAlgorithm(resolver));
        List<MemoryTask<XdIssue, XdUser>> filledTasks = algorithm.run(rawTasks);
        List<MemoryTask<XdIssue, XdUser>> sortedTopLevelTasks = GanttTopLevelTasksSorter.INSTANCE.addSorting(filledTasks);
        GanttReportDataBlobBuilder builder = new GanttReportDataBlobBuilder();
        Iterable $receiver$iv2 = sortedTopLevelTasks;
        for (Object element$iv : $receiver$iv2) {
            MemoryTask it = (MemoryTask)element$iv;
            boolean bl = false;
            builder.addTask(it);
        }
        return builder.build();
    }
}

