/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.history.interval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.smartui.parser.date.DatePeriod;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.core.dates.DateMath;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserKt;
import jetbrains.youtrack.reports.BeansKt;
import jetbrains.youtrack.reports.ReportCalculationMonitor;
import jetbrains.youtrack.reports.ReportsService;
import jetbrains.youtrack.reports.impl.history.DayDistributedDataBuilder;
import jetbrains.youtrack.reports.impl.history.interval.IntervalReportDataJson;
import jetbrains.youtrack.reports.impl.history.interval.XdAbstractIntervalReport;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0018\u0019\u001aB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/reports/impl/history/interval/LifetimeDataBuilder;", "Ljetbrains/youtrack/reports/impl/history/DayDistributedDataBuilder;", "Ljetbrains/youtrack/reports/impl/history/interval/LifetimeDataBuilder$DayData;", "report", "Ljetbrains/youtrack/reports/impl/history/interval/XdAbstractIntervalReport;", "period", "Ljetbrains/charisma/smartui/parser/date/DatePeriod;", "now", "", "(Ljetbrains/youtrack/reports/impl/history/interval/XdAbstractIntervalReport;Ljetbrains/charisma/smartui/parser/date/DatePeriod;J)V", "addInterval", "", "inTime", "outTime", "(JLjava/lang/Long;)V", "build", "Ljetbrains/youtrack/reports/impl/history/interval/IntervalReportDataJson;", "windowSize", "", "calculator", "Ljetbrains/youtrack/reports/ReportCalculationMonitor;", "collectIntervalsIntersectedRange", "monitor", "createDayData", "Companion", "DayData", "IntervalGroup", "youtrack-reports"})
public final class LifetimeDataBuilder
extends DayDistributedDataBuilder<DayData> {
    private final XdAbstractIntervalReport report;
    private static final int GUARD_DEFAULT_WINDOW_SIZE = 30;
    public static final Companion Companion = new Companion(null);

    private final void addInterval(long inTime, Long outTime) {
        long dayStart;
        Long l = outTime;
        long notNullOutTime = l != null ? l.longValue() : this.getNow();
        boolean wasNotNow = notNullOutTime != this.getNow();
        long l2 = dayStart = inTime < this.getFrom() ? this.getFrom() : this.getDayStart(inTime);
        while (dayStart < this.getTill()) {
            long nextDayStart = dayStart + 86400000L;
            Object v = this.getData().get(dayStart);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            DayData dayData = (DayData)v;
            if (notNullOutTime >= nextDayStart) {
                dayData.getLifetimes$youtrack_reports().add(nextDayStart - inTime);
            } else if (notNullOutTime >= dayStart) {
                dayData.getLifetimes$youtrack_reports().add(notNullOutTime - inTime);
                if (!wasNotNow) break;
                DayData dayData2 = dayData;
                int n = dayData2.getDied$youtrack_reports();
                dayData2.setDied$youtrack_reports(n + 1);
                break;
            }
            dayStart = nextDayStart;
        }
    }

    private final void collectIntervalsIntersectedRange(ReportCalculationMonitor monitor) {
        XdQuery issues2 = ReportsService.issuesOf$default(BeansKt.getReportsService(), this.report, null, null, false, 14, null);
        int size = XdQueryKt.size((XdQuery)issues2);
        int step = 0;
        Set<String> allowedState = this.report.getAllowedState();
        for (XdIssue issue2 : XdQueryKt.asSequence((XdQuery)issues2)) {
            Long outTime = null;
            for (Event event : this.report.getEvents(issue2)) {
                Long l = event.getTimestamp();
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"event.timestamp");
                long timestamp = l;
                if (this.report.isOutEvent(event, allowedState)) {
                    outTime = timestamp;
                    if (timestamp >= this.getFrom()) continue;
                    break;
                }
                if (!this.report.isInEvent(event, allowedState)) continue;
                if (outTime != null) {
                    if (timestamp < this.getTill()) {
                        this.addInterval(timestamp, outTime);
                    }
                    outTime = null;
                } else if (timestamp < this.getTill()) {
                    this.addInterval(timestamp, null);
                }
                if (timestamp >= this.getFrom()) continue;
                break;
            }
            monitor.setProgress(100 * ++step / size);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntervalReportDataJson build(int windowSize, @NotNull ReportCalculationMonitor calculator) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Collection<Long> collection;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)calculator, (String)"calculator");
        this.init();
        this.collectIntervalsIntersectedRange(calculator);
        ArrayList<IntervalGroup> groups2 = new ArrayList<IntervalGroup>(this.getData().size());
        long windowWidth = (long)(windowSize == 0 ? 30 : windowSize) * 86400000L;
        DateTimeZone timezone = XdUserKt.timezone((XdUser)this.report.getOwner());
        Object object8 = $receiver$iv = (Map)this.getData();
        Iterator iterator = object8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry day = element$iv = iterator.next();
            boolean bl = false;
            Long timestampUTC = DateMath.getSameDateStartInUTC((Long)((Long)day.getKey()), (DateTimeZone)timezone);
            DayData dayData = (DayData)day.getValue();
            Long l = timestampUTC;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"timestampUTC");
            groups2.add(dayData.calculate$youtrack_reports(l, windowWidth));
        }
        object8 = $receiver$iv = (Iterable)groups2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            item$iv$iv = iterator2.next();
            IntervalGroup bl = (IntervalGroup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object7 = it.getTimestamp();
            collection.add((Long)object7);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object7 = destination$iv$iv;
            boolean bl = false;
            object6 = it.getMax();
            object7.add(object6);
        }
        object7 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object6 = destination$iv$iv;
            boolean bl = false;
            object5 = it.getAvg();
            object6.add(object5);
        }
        object6 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object5 = destination$iv$iv;
            boolean bl = false;
            object4 = it.getMin();
            object5.add(object4);
        }
        object5 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object4 = destination$iv$iv;
            boolean bl = false;
            object3 = it.getMmx();
            object4.add(object3);
        }
        object4 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object2 = it.getMvg();
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getPositive();
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)groups2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            IntervalGroup it = (IntervalGroup)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getNegative();
            object.add(n);
        }
        Object object9 = object = (List)destination$iv$iv;
        Object object10 = object2;
        Object object11 = object3;
        Object object12 = object4;
        Object object13 = object5;
        Object object14 = object6;
        Object object15 = object7;
        Collection<Long> collection2 = collection;
        return new IntervalReportDataJson((List<Long>)collection2, (List<Long>)object15, (List<Long>)object14, (List<Long>)object13, (List<Long>)object12, (List<Long>)object11, (List<Integer>)object10, (List<Integer>)object9);
    }

    @Override
    @NotNull
    protected DayData createDayData() {
        return new DayData();
    }

    public LifetimeDataBuilder(@NotNull XdAbstractIntervalReport report2, @NotNull DatePeriod period, long now) {
        Intrinsics.checkParameterIsNotNull((Object)report2, (String)"report");
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        super(period, now);
        this.report = report2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/reports/impl/history/interval/LifetimeDataBuilder$DayData;", "", "()V", "died", "", "getDied$youtrack_reports", "()I", "setDied$youtrack_reports", "(I)V", "lifetimes", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getLifetimes$youtrack_reports", "()Ljava/util/ArrayList;", "calculate", "Ljetbrains/youtrack/reports/impl/history/interval/LifetimeDataBuilder$IntervalGroup;", "timestamp", "windowWidth", "calculate$youtrack_reports", "youtrack-reports"})
    public static final class DayData {
        @NotNull
        private final ArrayList<Long> lifetimes;
        private int died;

        @NotNull
        public final ArrayList<Long> getLifetimes$youtrack_reports() {
            return this.lifetimes;
        }

        public final int getDied$youtrack_reports() {
            return this.died;
        }

        public final void setDied$youtrack_reports(int n) {
            this.died = n;
        }

        @NotNull
        public final IntervalGroup calculate$youtrack_reports(long timestamp, long windowWidth) {
            int summaryNumber = this.lifetimes.size();
            if (summaryNumber == 0) {
                return new IntervalGroup(timestamp, 0L, 0L, 0L, 0L, 0L, 0, 0);
            }
            long summaryTime = 0L;
            long minT = Long.MAX_VALUE;
            long maxT = 0L;
            long maxWndT = 0L;
            long windowTime = 0L;
            int windowNumber = 0;
            Iterator<Long> iterator = this.lifetimes.iterator();
            while (iterator.hasNext()) {
                Long lifetime;
                Long l = lifetime = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"lifetime");
                summaryTime += l.longValue();
                if (lifetime > maxT) {
                    maxT = lifetime;
                }
                if (lifetime < minT) {
                    minT = lifetime;
                }
                if (lifetime > windowWidth) continue;
                if (lifetime > maxWndT) {
                    maxWndT = lifetime;
                }
                windowTime += lifetime.longValue();
                ++windowNumber;
            }
            long avgT = summaryTime / (long)summaryNumber;
            long avgWndT = windowNumber == 0 ? 0L : windowTime / (long)windowNumber;
            return new IntervalGroup(timestamp, maxT, avgT, minT, maxWndT, avgWndT, this.died, summaryNumber - this.died);
        }

        public DayData() {
            DayData dayData = this;
            ArrayList arrayList = new ArrayList();
            dayData.lifetimes = arrayList;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003JY\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\nH\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006&"}, d2={"Ljetbrains/youtrack/reports/impl/history/interval/LifetimeDataBuilder$IntervalGroup;", "", "timestamp", "", "max", "avg", "min", "mmx", "mvg", "positive", "", "negative", "(JJJJJJII)V", "getAvg", "()J", "getMax", "getMin", "getMmx", "getMvg", "getNegative", "()I", "getPositive", "getTimestamp", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "", "youtrack-reports"})
    public static final class IntervalGroup {
        private final long timestamp;
        private final long max;
        private final long avg;
        private final long min;
        private final long mmx;
        private final long mvg;
        private final int positive;
        private final int negative;

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final long getMax() {
            return this.max;
        }

        public final long getAvg() {
            return this.avg;
        }

        public final long getMin() {
            return this.min;
        }

        public final long getMmx() {
            return this.mmx;
        }

        public final long getMvg() {
            return this.mvg;
        }

        public final int getPositive() {
            return this.positive;
        }

        public final int getNegative() {
            return this.negative;
        }

        public IntervalGroup(long timestamp, long max, long avg, long min, long mmx, long mvg, int positive, int negative) {
            this.timestamp = timestamp;
            this.max = max;
            this.avg = avg;
            this.min = min;
            this.mmx = mmx;
            this.mvg = mvg;
            this.positive = positive;
            this.negative = negative;
        }

        public final long component1() {
            return this.timestamp;
        }

        public final long component2() {
            return this.max;
        }

        public final long component3() {
            return this.avg;
        }

        public final long component4() {
            return this.min;
        }

        public final long component5() {
            return this.mmx;
        }

        public final long component6() {
            return this.mvg;
        }

        public final int component7() {
            return this.positive;
        }

        public final int component8() {
            return this.negative;
        }

        @NotNull
        public final IntervalGroup copy(long timestamp, long max, long avg, long min, long mmx, long mvg, int positive, int negative) {
            return new IntervalGroup(timestamp, max, avg, min, mmx, mvg, positive, negative);
        }

        @NotNull
        public static /* synthetic */ IntervalGroup copy$default(IntervalGroup intervalGroup, long l, long l2, long l3, long l4, long l5, long l6, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = intervalGroup.timestamp;
            }
            if ((n3 & 2) != 0) {
                l2 = intervalGroup.max;
            }
            if ((n3 & 4) != 0) {
                l3 = intervalGroup.avg;
            }
            if ((n3 & 8) != 0) {
                l4 = intervalGroup.min;
            }
            if ((n3 & 0x10) != 0) {
                l5 = intervalGroup.mmx;
            }
            if ((n3 & 0x20) != 0) {
                l6 = intervalGroup.mvg;
            }
            if ((n3 & 0x40) != 0) {
                n = intervalGroup.positive;
            }
            if ((n3 & 0x80) != 0) {
                n2 = intervalGroup.negative;
            }
            return intervalGroup.copy(l, l2, l3, l4, l5, l6, n, n2);
        }

        @NotNull
        public String toString() {
            return "IntervalGroup(timestamp=" + this.timestamp + ", max=" + this.max + ", avg=" + this.avg + ", min=" + this.min + ", mmx=" + this.mmx + ", mvg=" + this.mvg + ", positive=" + this.positive + ", negative=" + this.negative + ")";
        }

        public int hashCode() {
            return ((((((Long.hashCode(this.timestamp) * 31 + Long.hashCode(this.max)) * 31 + Long.hashCode(this.avg)) * 31 + Long.hashCode(this.min)) * 31 + Long.hashCode(this.mmx)) * 31 + Long.hashCode(this.mvg)) * 31 + Integer.hashCode(this.positive)) * 31 + Integer.hashCode(this.negative);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IntervalGroup)) break block3;
                    IntervalGroup intervalGroup = (IntervalGroup)object;
                    if (!(this.timestamp == intervalGroup.timestamp) || !(this.max == intervalGroup.max) || !(this.avg == intervalGroup.avg) || !(this.min == intervalGroup.min) || !(this.mmx == intervalGroup.mmx) || !(this.mvg == intervalGroup.mvg) || !(this.positive == intervalGroup.positive) || !(this.negative == intervalGroup.negative)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/reports/impl/history/interval/LifetimeDataBuilder$Companion;", "", "()V", "GUARD_DEFAULT_WINDOW_SIZE", "", "youtrack-reports"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

