/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.reports.impl.time.sheet;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import jetbrains.charisma.date.BeansKt;
import jetbrains.charisma.date.DateTimeFormattersImpl;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.youtrack.api.reports.DataExportWriter;
import jetbrains.youtrack.reports.export.XlsxDataExportWriter;
import jetbrains.youtrack.reports.impl.time.HeaderStyledRow;
import jetbrains.youtrack.reports.impl.time.sheet.TimeSheetDataJson;
import jetbrains.youtrack.reports.impl.time.sheet.TimeSheetHeaderJson;
import jetbrains.youtrack.reports.impl.time.sheet.XdTimeSheetReportScale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/reports/impl/time/sheet/HeaderRow;", "Ljetbrains/youtrack/reports/impl/time/HeaderStyledRow;", "data", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetDataJson;", "hasGrouping", "", "userView", "scale", "Ljetbrains/youtrack/reports/impl/time/sheet/XdTimeSheetReportScale;", "(Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetDataJson;ZZLjetbrains/youtrack/reports/impl/time/sheet/XdTimeSheetReportScale;)V", "getData", "()Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetDataJson;", "getHasGrouping", "()Z", "monthsFormatter", "Ljava/text/SimpleDateFormat;", "getScale", "()Ljetbrains/youtrack/reports/impl/time/sheet/XdTimeSheetReportScale;", "getUserView", "weeksFormatter", "excelWrite", "", "context", "Ljetbrains/youtrack/reports/export/XlsxDataExportWriter;", "simpleWrite", "Ljetbrains/youtrack/api/reports/DataExportWriter;", "writeCSV", "formatter", "it", "Ljetbrains/youtrack/reports/impl/time/sheet/TimeSheetHeaderJson;", "writeExcel", "youtrack-reports"})
final class HeaderRow
implements HeaderStyledRow {
    private final SimpleDateFormat weeksFormatter;
    private final SimpleDateFormat monthsFormatter;
    @NotNull
    private final TimeSheetDataJson data;
    private final boolean hasGrouping;
    private final boolean userView;
    @NotNull
    private final XdTimeSheetReportScale scale;

    @Override
    public void excelWrite(@NotNull XlsxDataExportWriter context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        context2.writeString(this.hasGrouping ? "Group/Item" : "Item", (Function1<? super SXSSFCell, Unit>)((Function1)new Function1<SXSSFCell, Unit>(this){
            final /* synthetic */ HeaderRow this$0;

            public final void invoke(@NotNull SXSSFCell $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                this.this$0.withGreyFont(this.this$0.withBottomBorder($receiver));
            }
            {
                this.this$0 = headerRow;
                super(1);
            }
        }));
        if (!this.userView) {
            context2.writeString("Estimation", this.getHeaderCellStyle());
            context2.writeString("Total spent time", this.getHeaderCellStyle());
        }
        context2.writeString("Spent time", this.getHeaderCellStyle());
        Iterable $receiver$iv = this.data.getHeaders();
        for (Object element$iv : $receiver$iv) {
            TimeSheetHeaderJson it = (TimeSheetHeaderJson)element$iv;
            boolean bl = false;
            XdTimeSheetReportScale xdTimeSheetReportScale = this.scale;
            if (Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getDAY()))) {
                context2.writeDate(it.getStart(), this.getHeaderCellStyle());
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getWEEK()))) {
                this.writeExcel(context2, this.weeksFormatter, it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getMONTH()))) continue;
            this.writeExcel(context2, this.monthsFormatter, it);
        }
    }

    @Override
    public void simpleWrite(@NotNull DataExportWriter context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        context2.writeString("Group name");
        context2.writeString("Item");
        context2.writeString("Estimation");
        context2.writeString("Total spent time");
        context2.writeString("Spent time");
        Iterable $receiver$iv = this.data.getHeaders();
        for (Object element$iv : $receiver$iv) {
            TimeSheetHeaderJson it = (TimeSheetHeaderJson)element$iv;
            boolean bl = false;
            XdTimeSheetReportScale xdTimeSheetReportScale = this.scale;
            if (Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getDAY()))) {
                context2.writeDate(Long.valueOf(it.getStart()));
                continue;
            }
            if (Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getWEEK()))) {
                this.writeCSV(context2, this.weeksFormatter, it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Object)xdTimeSheetReportScale), (Object)((Object)XdTimeSheetReportScale.Companion.getMONTH()))) continue;
            this.writeCSV(context2, this.monthsFormatter, it);
        }
    }

    private final void writeExcel(XlsxDataExportWriter context2, SimpleDateFormat formatter, TimeSheetHeaderJson it) {
        context2.writeString(formatter.format(it.getStart()) + " - " + formatter.format(it.getEnd()), (Function1<? super SXSSFCell, Unit>)((Function1)new Function1<SXSSFCell, Unit>(this){
            final /* synthetic */ HeaderRow this$0;

            public final void invoke(@NotNull SXSSFCell $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                this.this$0.withGreyFont(this.this$0.withBottomBorder($receiver));
            }
            {
                this.this$0 = headerRow;
                super(1);
            }
        }));
    }

    private final void writeCSV(DataExportWriter context2, SimpleDateFormat formatter, TimeSheetHeaderJson it) {
        context2.writeString(formatter.format(it.getStart()) + " - " + formatter.format(it.getEnd()));
    }

    @NotNull
    public final TimeSheetDataJson getData() {
        return this.data;
    }

    public final boolean getHasGrouping() {
        return this.hasGrouping;
    }

    public final boolean getUserView() {
        return this.userView;
    }

    @NotNull
    public final XdTimeSheetReportScale getScale() {
        return this.scale;
    }

    public HeaderRow(@NotNull TimeSheetDataJson data, boolean hasGrouping, boolean userView, @NotNull XdTimeSheetReportScale scale) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scale), (String)"scale");
        this.data = data;
        this.hasGrouping = hasGrouping;
        this.userView = userView;
        this.scale = scale;
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd MMM");
        HeaderRow headerRow = this;
        SimpleDateFormat it = simpleDateFormat2;
        boolean bl = false;
        it.setTimeZone(TimeZone.getTimeZone("UTC"));
        headerRow.weeksFormatter = simpleDateFormat = simpleDateFormat2;
        DateTimeFormattersImpl dateTimeFormattersImpl = BeansKt.getDateFormatter();
        GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        this.monthsFormatter = new SimpleDateFormat(dateTimeFormattersImpl.getDatePatternForName(generalUserProfile.getDateFieldFormat()));
    }

    @Override
    @NotNull
    public Function1<SXSSFCell, Unit> getHeaderCellStyle() {
        return HeaderStyledRow.DefaultImpls.getHeaderCellStyle(this);
    }

    @Override
    @NotNull
    public Function1<SXSSFCell, Unit> getTotalCellStyle() {
        return HeaderStyledRow.DefaultImpls.getTotalCellStyle(this);
    }

    @Override
    public void write(@NotNull DataExportWriter context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        HeaderStyledRow.DefaultImpls.write(this, context2);
    }

    @Override
    @NotNull
    public SXSSFCell bold(@NotNull SXSSFCell $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HeaderStyledRow.DefaultImpls.bold(this, $receiver);
    }

    @Override
    @NotNull
    public SXSSFCell withGreyFont(@NotNull SXSSFCell $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HeaderStyledRow.DefaultImpls.withGreyFont(this, $receiver);
    }

    @Override
    @NotNull
    public SXSSFCell withBottomBorder(@NotNull SXSSFCell $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HeaderStyledRow.DefaultImpls.withBottomBorder(this, $receiver);
    }

    @Override
    @NotNull
    public SXSSFCell withGrayBackground(@NotNull SXSSFCell $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return HeaderStyledRow.DefaultImpls.withGrayBackground(this, $receiver);
    }

    @Override
    public void writeIssueLink(@NotNull XlsxDataExportWriter $receiver, @Nullable String idReadable2, @Nullable String summary2, @Nullable String url, @Nullable Function1<? super SXSSFCell, Unit> tweak) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        HeaderStyledRow.DefaultImpls.writeIssueLink(this, $receiver, idReadable2, summary2, url, tweak);
    }
}

