/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.youtrack.service;

import com.jetbrains.service.util.BundleEnvironmentProperty;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.contract.callbacks.impl.log4j.BeforeStartCallback;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class YouTrackBeforeStartCallback
extends BeforeStartCallback {
    protected void doPerform(@NotNull Map<String, Object> map) {
        this.setupSystemProperties(ConfiguratorUtils.loadPropertiesFile((File)this.getServiceConfigFile(map)));
    }

    void setupSystemProperties(@NotNull Properties serviceProperties) {
        String bundledInService;
        String collectUsageStatistics;
        boolean newYouTrackInstallation = !YouTrackBeforeStartCallback.isExistingYoutrackInstallation(serviceProperties);
        System.setProperty("jetbrains.youtrack.ring.enabled", "true");
        System.setProperty("jetbrains.youtrack.ring.url", YouTrackBeforeStartCallback.computeHubUrl(serviceProperties));
        if (!YouTrackBeforeStartCallback.isYouTrackBundle(serviceProperties)) {
            System.setProperty("jetbrains.youtrack.default.page", "/issues");
        }
        String trustStorePath = serviceProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName());
        String trustStorePassword = serviceProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName());
        String trustStoreKeyPassword = serviceProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_HUB_KEY_PASSWORD.getPrefixedName());
        if (trustStorePath != null) {
            System.setProperty("jetbrains.youtrack.ssl.trustStorePath", trustStorePath);
        }
        if (trustStorePassword != null) {
            System.setProperty("jetbrains.youtrack.ssl.trustStorePassword", trustStorePassword);
        }
        if (trustStoreKeyPassword != null) {
            System.setProperty("jetbrains.youtrack.ssl.trustStoreKeyPassword", trustStoreKeyPassword);
        }
        System.setProperty("jetbrains.youtrack.statistics.enabled", (collectUsageStatistics = serviceProperties.getProperty(BundleProperty.STATISTICS_UPLOAD.getPrefixedName())) == null ? "false" : collectUsageStatistics);
        if (PropertiesBasedConfigurationHelper.getHelper().isServiceEnabled((Object)serviceProperties, "hub")) {
            String hubDataDir = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)serviceProperties, "hub", ServiceProperties.DATA_DIR_PROPERTY);
            if (hubDataDir != null) {
                System.setProperty("jetbrains.youtrack.backup.hubDatabaseLocation", hubDataDir);
            }
        } else {
            System.setProperty("jetbrains.youtrack.disableBundledHub", "true");
        }
        String serviceId = serviceProperties.getProperty("hub-service-id");
        String serviceSecret = serviceProperties.getProperty("hub-service-secret");
        if (serviceId != null) {
            System.setProperty("jetbrains.youtrack.ring.service.id", serviceId);
            if (serviceSecret != null) {
                System.setProperty("jetbrains.youtrack.ring.service.secret", serviceSecret);
            }
        }
        System.setProperty("jetbrains.youtrack.baseUrl", serviceProperties.getProperty("base-url"));
        String backupsDir = YouTrackBeforeStartCallback.isYouTrackBundle(serviceProperties) ? serviceProperties.getProperty(BundleProperty.BACKUPS_DIR.getPrefixedName()) : serviceProperties.getProperty(ServiceProperties.BACKUPS_DIR_PROPERTY);
        if (backupsDir != null) {
            System.setProperty("database.backup.location", backupsDir);
        }
        if (newYouTrackInstallation) {
            String bundleLocale;
            String overriddenRootPassword;
            String overriddenRootLogin = serviceProperties.getProperty(BundleProperty.ROOT_USER.getPrefixedName());
            if (overriddenRootLogin != null) {
                System.setProperty("jetbrains.youtrack.root.login", overriddenRootLogin);
            }
            if ((overriddenRootPassword = serviceProperties.getProperty(BundleProperty.ROOT_PASSWORD.getPrefixedName())) != null) {
                System.setProperty("jetbrains.youtrack.overrideRootPassword", overriddenRootPassword);
            }
            if ((bundleLocale = serviceProperties.getProperty(BundleProperty.LOCALE.getPrefixedName())) != null) {
                System.setProperty("jetbrains.youtrack.locale", bundleLocale);
            }
        }
        String licenseName = serviceProperties.getProperty("license-user-name");
        String licenseKey = serviceProperties.getProperty("license-key");
        if (YouTrackBeforeStartCallback.isNotEmpty(licenseName) && YouTrackBeforeStartCallback.isNotEmpty(licenseKey)) {
            System.setProperty("jetbrains.youtrack.licenseName", licenseName);
            System.setProperty("jetbrains.youtrack.licenseKey", licenseKey);
        }
        if ((bundledInService = serviceProperties.getProperty("bundledin")) != null) {
            System.setProperty("service.youtrack.bundledin", bundledInService);
        }
        String confDir = serviceProperties.getProperty(BundleEnvironmentProperty.CONF_DIR.getPrefixedName());
        System.setProperty("jetbrains.youtrack.backup.confLocation", confDir);
        System.setProperty("jetbrains.youtrack.logDir", serviceProperties.getProperty(ServiceProperties.LOGS_DIR_PROPERTY));
        System.setProperty("jetbrains.youtrack.standalone.port", serviceProperties.getProperty("port"));
        System.setProperty("jetbrains.youtrack.standalone.host", serviceProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getPrefixedName()));
        System.setProperty("jetbrains.youtrack.installation-type", "BUNDLE");
        System.setProperty("jetbrains.youtrack.installation-dir", serviceProperties.getProperty("bundle.installation-dir"));
        File serviceDataDir = new File(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)serviceProperties, ServiceProperties.DATA_DIR_PROPERTY));
        System.setProperty("database.location", (new File(serviceDataDir, "youtrack").exists() ? serviceDataDir : serviceDataDir.getParentFile()).getAbsolutePath());
        String bundleConfiguratorUri = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)serviceProperties, "adminService", "context");
        if (bundleConfiguratorUri != null) {
            System.setProperty("jetbrains.youtrack.ring.configurator.uri", bundleConfiguratorUri);
        }
        String bundleConfiguratorInternalUrl = PropertiesBasedConfigurationHelper.getHelper().getServiceInternalBaseUrl((Object)serviceProperties, "bundleBackend");
        System.setProperty("jetbrains.youtrack.ring.configurator.internalUrl", bundleConfiguratorInternalUrl);
    }

    private static String computeHubUrl(@NotNull Properties serviceProperties) {
        String hubUrl = serviceProperties.getProperty("hub-url");
        String internalHubUrl = PropertiesBasedConfigurationHelper.getHelper().getInternalHubUrl((Object)serviceProperties);
        boolean isEmbedded = "true".equals(serviceProperties.getProperty("jetbrains.youtrack.hasEmbeddedHub"));
        return isEmbedded ? internalHubUrl : hubUrl;
    }

    private static boolean isExistingYoutrackInstallation(@NotNull Properties properties) {
        return YouTrackBeforeStartCallback.isYouTrackBundle(properties) && YouTrackBeforeStartCallback.isExistingInstallation(properties);
    }

    private static boolean isYouTrackBundle(@NotNull Properties properties) {
        return "YouTrack".equalsIgnoreCase(properties.getProperty("bundle.product.name"));
    }

    private static boolean isExistingInstallation(@NotNull Properties properties) {
        String dbYouTrackLocation = properties.getProperty(ServiceProperties.DATA_DIR_PROPERTY);
        try {
            return YouTrackBeforeStartCallback.isDatabaseDir(new File(dbYouTrackLocation)) || YouTrackBeforeStartCallback.isDatabaseDir(new File(dbYouTrackLocation, "youtrack"));
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static boolean isDatabaseDir(File directory) throws IOException {
        if (directory.exists()) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory.toPath());){
                for (Path f : dirStream) {
                    if (!f.toString().toLowerCase().endsWith(".xd")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }
}

