/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.PathResolver;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseMacDaemonSubCommand;
import com.jetbrains.launcher.ep.commands.Configure;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.ConfiguringArgumentsParser;
import com.jetbrains.launcher.util.ExceptionUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacDaemonInstall
extends BaseMacDaemonSubCommand {
    @NotNull
    private static final String NAME = "install";
    @NotNull
    private static final String USER_OPTION = "user";
    @NotNull
    private final Logger LOG = Logger.getLogger(MacDaemonInstall.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            MacDaemonInstall.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    protected boolean requiresInstalledService() {
        return false;
    }

    @Override
    @Nullable
    public LauncherExitCode configureService(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            MacDaemonInstall.$$$reportNull$$$0(1);
        }
        try {
            Arguments args = context.getArguments();
            HashMap options = new HashMap(new ConfiguringArgumentsParser(args.getApplicationArguments(), (PathResolver)context.getAppFiles(), false, false).getProperties());
            String user = (String)options.remove(USER_OPTION);
            if (!options.isEmpty()) {
                this.LOG.error((Object)"Only the \"--user\" option is allowed");
                return LauncherExitCode.WRONG_USAGE;
            }
            if (user != null) {
                LauncherExitCode code = new Configure().reinitLogsAndDoRun(context.withArguments(args.withCmdLine(new String[]{"--launcher", "--mac-daemon-user", user})));
                if (code != LauncherExitCode.OK) {
                    return code;
                }
                this.initLogs((LauncherContext)context);
            }
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to configure JetLauncher", (Throwable)e);
            return LauncherExitCode.ERROR;
        }
        return super.configureService((LauncherContextEx)new UpToDateLauncherContext(context));
    }

    @Override
    @NotNull
    protected LauncherExitCode runUnderRoot(@NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode exitCode;
        if (context == null) {
            MacDaemonInstall.$$$reportNull$$$0(2);
        }
        if ((exitCode = super.runUnderRoot(context)) == LauncherExitCode.OK) {
            this.LOG.info((Object)(context.getAppConfig().getAppName().getCapitalizedName() + " daemon was installed"));
        }
        LauncherExitCode launcherExitCode = exitCode;
        if (launcherExitCode == null) {
            MacDaemonInstall.$$$reportNull$$$0(3);
        }
        return launcherExitCode;
    }

    @Override
    @NotNull
    protected String getMacDaemonScriptCommand() {
        if (NAME == null) {
            MacDaemonInstall.$$$reportNull$$$0(4);
        }
        return NAME;
    }

    @Override
    protected void addCustomMacDaemonScriptArguments(@NotNull List<String> args, @NotNull LauncherContext context) {
        if (args == null) {
            MacDaemonInstall.$$$reportNull$$$0(5);
        }
        if (context == null) {
            MacDaemonInstall.$$$reportNull$$$0(6);
        }
        args.add(context.getAppFiles().getAppInternalConfFolder().getAbsolutePath());
    }

    @Nullable
    protected LauncherExitCode afterServiceConfigured(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            MacDaemonInstall.$$$reportNull$$$0(7);
        }
        return this.afterServiceConfiguredForInstall(context);
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            MacDaemonInstall.$$$reportNull$$$0(8);
        }
        if (context == null) {
            MacDaemonInstall.$$$reportNull$$$0(9);
        }
        printer.print(this.getFullName(), "installs " + context.getAppConfig().getAppName().getName() + " daemon, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            MacDaemonInstall.$$$reportNull$$$0(10);
        }
        if (context == null) {
            MacDaemonInstall.$$$reportNull$$$0(11);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(this.getFullName() + " " + "--" + USER_OPTION + "=<user>", "remembers the specified user and installs " + name + " daemon to be run under this account");
        printer.print(this.getFullName() + " " + "--" + USER_OPTION + " <user>", "remembers the specified user and installs " + name + " daemon to be run under this account");
        printer.print(this.getFullName(), "installs " + name + " daemon to be run under the previously remembered user or under the \"root\" user by default");
        MacDaemonInstall.printSudoInfo();
        ConsoleLogger.error((String)"Use \"--force\" option to uninstall the daemon first in case it already exists");
        ConsoleLogger.error();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/MacDaemonInstall";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/MacDaemonInstall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runUnderRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacDaemonScriptCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureService";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runUnderRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCustomMacDaemonScriptArguments";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "afterServiceConfigured";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

