/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import org.jetbrains.annotations.NotNull;

public class FixedLengthByteIterable
extends ByteIterableBase {
    protected final ByteIterable source;
    protected final int offset;

    protected FixedLengthByteIterable(@NotNull ByteIterable source, int offset, int length) {
        if (length < 0) {
            throw new ExodusException("ByteIterable length can't be less than zero");
        }
        this.source = source;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        int safeLength = Math.min(length, this.length - offset);
        return safeLength == 0 ? EMPTY : new FixedLengthByteIterable(this.source, this.offset + offset, safeLength);
    }

    public ByteIterable getSource() {
        return this.source;
    }

    @Override
    protected ByteIterator getIterator() {
        if (this.length == 0) {
            return ByteIterable.EMPTY_ITERATOR;
        }
        final ByteIterator bi = this.source.iterator();
        bi.skip(this.offset);
        return new ByteIterator(){
            private int i;
            {
                this.i = FixedLengthByteIterable.this.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0 && bi.hasNext();
            }

            @Override
            public byte next() {
                --this.i;
                return bi.next();
            }

            @Override
            public long skip(long bytes) {
                long result = bi.skip(Math.min(bytes, (long)this.i));
                this.i -= (int)result;
                return result;
            }
        };
    }
}

