/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.backup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupBean
implements Backupable {
    private static final Logger logger = LoggerFactory.getLogger(BackupBean.class);
    private final Backupable[] targets;
    private volatile long backupStartTicks;
    private String backupPath;
    private boolean backupToZip;
    private String backupNamePrefix;
    private String commandAfterBackup;
    private List<Runnable> runAfterBackup = new ArrayList<Runnable>();
    private Throwable backupException;

    public BackupBean(Backupable target) {
        this.targets = new Backupable[]{target};
    }

    public BackupBean(List<Backupable> targets) {
        int targetsCount = targets.size();
        if (targetsCount < 1) {
            throw new IllegalArgumentException();
        }
        this.targets = targets.toArray(new Backupable[targetsCount]);
    }

    public void setBackupPath(@NotNull String backupPath) {
        this.backupPath = backupPath;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public boolean getBackupToZip() {
        return this.backupToZip;
    }

    public void setBackupToZip(boolean zip) {
        this.backupToZip = zip;
    }

    public String getBackupNamePrefix() {
        return this.backupNamePrefix;
    }

    public void setBackupNamePrefix(String prefix) {
        this.backupNamePrefix = prefix;
    }

    public void setCommandAfterBackup(@Nullable String command) {
        this.commandAfterBackup = command;
    }

    public String getCommandAfterBackup() {
        return this.commandAfterBackup;
    }

    public void executeAfterBackup(@NotNull Runnable runnable) {
        this.runAfterBackup.add(runnable);
    }

    public void setBackupStartTicks(long backupStartTicks) {
        this.backupStartTicks = backupStartTicks;
    }

    public long getBackupStartTicks() {
        return this.backupStartTicks;
    }

    public boolean isBackupInProgress() {
        return this.backupStartTicks > 0L;
    }

    public void setBackupException(Throwable backupException) {
        this.backupException = backupException;
    }

    public Throwable getBackupException() {
        return this.backupException;
    }

    @Override
    public BackupStrategy getBackupStrategy() {
        final int targetsCount = this.targets.length;
        final BackupStrategy[] wrapped = new BackupStrategy[targetsCount];
        for (int i = 0; i < targetsCount; ++i) {
            wrapped[i] = this.targets[i].getBackupStrategy();
        }
        return new BackupStrategy(){

            @Override
            public void beforeBackup() throws Exception {
                BackupBean.this.backupStartTicks = System.currentTimeMillis();
                logger.info("Backing up database...");
                for (BackupStrategy strategy : wrapped) {
                    strategy.beforeBackup();
                }
            }

            @Override
            public Iterable<BackupStrategy.FileDescriptor> listFiles() {
                return new Iterable<BackupStrategy.FileDescriptor>(){

                    @Override
                    public Iterator<BackupStrategy.FileDescriptor> iterator() {
                        return new Iterator<BackupStrategy.FileDescriptor>(){
                            @Nullable
                            private BackupStrategy.FileDescriptor next = null;
                            private int i = 0;
                            @NotNull
                            private Iterator<BackupStrategy.FileDescriptor> it = BackupStrategy.EMPTY.listFiles().iterator();

                            @Override
                            public boolean hasNext() {
                                return this.getNext() != null;
                            }

                            @Override
                            public BackupStrategy.FileDescriptor next() {
                                try {
                                    BackupStrategy.FileDescriptor fileDescriptor = this.getNext();
                                    return fileDescriptor;
                                }
                                finally {
                                    this.next = null;
                                }
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("remove");
                            }

                            private BackupStrategy.FileDescriptor getNext() {
                                long acceptedSize;
                                if (this.next == null) {
                                    while (!this.it.hasNext()) {
                                        if (this.i >= targetsCount) {
                                            return this.next;
                                        }
                                        this.it = wrapped[this.i++].listFiles().iterator();
                                    }
                                    this.next = this.it.next();
                                }
                                if ((acceptedSize = wrapped[this.i - 1].acceptFile(this.next.getFile())) < this.next.getFileSize()) {
                                    return new BackupStrategy.FileDescriptor(this.next.getFile(), this.next.getPath(), acceptedSize);
                                }
                                return this.next;
                            }
                        };
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void afterBackup() throws Exception {
                try {
                    for (BackupStrategy strategy : wrapped) {
                        strategy.afterBackup();
                    }
                }
                finally {
                    BackupBean.this.backupStartTicks = 0L;
                }
                for (Runnable runnable : BackupBean.this.runAfterBackup) {
                    runnable.run();
                }
                if (BackupBean.this.commandAfterBackup != null) {
                    logger.info("Executing \"" + BackupBean.this.commandAfterBackup + "\"...");
                    Runtime.getRuntime().exec(BackupBean.this.commandAfterBackup);
                }
                logger.info("Backup finished.");
            }

            @Override
            public void onError(Throwable t) {
                BackupBean.this.backupException = t;
            }
        };
    }
}

