/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.backup;

import java.io.File;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class BackupStrategy {
    public static final BackupStrategy EMPTY = new BackupStrategy(){

        @Override
        public Iterable<FileDescriptor> listFiles() {
            return Collections.emptyList();
        }
    };

    public void beforeBackup() throws Exception {
    }

    public abstract Iterable<FileDescriptor> listFiles();

    public void afterBackup() throws Exception {
    }

    public boolean isInterrupted() {
        return false;
    }

    public void onError(Throwable t) {
    }

    public long acceptFile(@NotNull File file) {
        return Long.MAX_VALUE;
    }

    public static class FileDescriptor {
        @NotNull
        private final File file;
        @NotNull
        private final String path;
        private final long fileSize;

        public FileDescriptor(@NotNull File file, @NotNull String path, long fileSize) {
            this.file = file;
            this.path = path;
            this.fileSize = fileSize;
        }

        public FileDescriptor(@NotNull File file, @NotNull String path) {
            this(file, path, file.length());
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public File getFile() {
            return this.file;
        }

        public long getFileSize() {
            return this.fileSize;
        }
    }
}

