/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparableSet<T extends Comparable<T>>
implements Comparable<ComparableSet<T>>,
Iterable<T> {
    @NotNull
    private final NavigableSet<T> set = new TreeSet<T>();
    private boolean isDirty;

    public ComparableSet() {
        this.isDirty = false;
    }

    public ComparableSet(@NotNull Iterable<T> it) {
        for (Comparable item : it) {
            this.set.add(item);
        }
        this.isDirty = false;
    }

    @Override
    public int compareTo(@NotNull ComparableSet<T> right) {
        if (this.isEmpty() || !this.getItemClass().equals(String.class)) {
            return this.caseSensitiveCompareTo(right);
        }
        return this.caseInsensitiveCompareTo(right);
    }

    public T getMinimum() {
        return (T)((Comparable)this.set.first());
    }

    public T getMaximum() {
        return (T)((Comparable)this.set.last());
    }

    public ComparableSet<T> minus(@Nullable ComparableSet<T> subtrahend) {
        if (subtrahend == null) {
            return this;
        }
        ComparableSet<Comparable> result = new ComparableSet<Comparable>();
        for (Comparable item : this.set) {
            if (subtrahend.set.contains(item)) continue;
            result.addItem(item);
        }
        return result;
    }

    public boolean containsItem(@NotNull T item) {
        return this.set.contains(item);
    }

    public boolean addItem(@NotNull T item) {
        boolean result = this.set.add(item);
        this.isDirty |= result;
        return result;
    }

    public boolean removeItem(@NotNull T item) {
        boolean result = this.set.remove(item);
        this.isDirty |= result;
        return result;
    }

    public int size() {
        return this.set.size();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void forEach(@NotNull Consumer<T> action) {
        int index = 0;
        for (Comparable item : this.set) {
            action.accept(item, index++);
        }
    }

    public T[] toArray() {
        return this.set.toArray(new Comparable[this.size()]);
    }

    public boolean equals(Object o) {
        return o != null && this.set.equals(((ComparableSet)o).set);
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public String toString() {
        return "ComparableSet" + this.set;
    }

    @Nullable
    public Class<? extends Comparable> getItemClass() {
        Iterator<T> it = this.set.iterator();
        return it.hasNext() ? ((Comparable)it.next()).getClass() : null;
    }

    void setIsDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    private int caseSensitiveCompareTo(@NotNull ComparableSet<T> right) {
        Iterator<T> thisIt = this.set.iterator();
        Iterator<T> rightIt = right.set.iterator();
        while (thisIt.hasNext() && rightIt.hasNext()) {
            int cmp = ((Comparable)thisIt.next()).compareTo(rightIt.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (thisIt.hasNext()) {
            return 1;
        }
        if (rightIt.hasNext()) {
            return -1;
        }
        return 0;
    }

    private int caseInsensitiveCompareTo(@NotNull ComparableSet<T> right) {
        Iterator<T> thisIt = this.set.iterator();
        Iterator<T> rightIt = right.set.iterator();
        while (thisIt.hasNext() && rightIt.hasNext()) {
            int cmp = ((String)thisIt.next()).compareToIgnoreCase((String)rightIt.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (thisIt.hasNext()) {
            return 1;
        }
        if (rightIt.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static interface Consumer<T extends Comparable<T>> {
        public void accept(@NotNull T var1, int var2);
    }
}

