/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.core.dataStructures.SoftLongObjectCache;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import jetbrains.exodus.util.IOUtil;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.exodus.util.UTFUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlobVault
implements BlobHandleGenerator,
Backupable {
    private static final int STRING_CONTENT_CACHE_SIZE = 4096;
    private static final int READ_BUFFER_SIZE = 16384;
    private final Object stringContentCacheLock = new Object();
    private SoftLongObjectCache<String> stringContentCache = new SoftLongObjectCache(4096);
    protected final ByteArraySpinAllocator bufferAllocator = new ByteArraySpinAllocator(16384);

    protected BlobVault() {
    }

    @Nullable
    public abstract InputStream getContent(long var1, @NotNull Transaction var3);

    public abstract long getSize(long var1, @NotNull Transaction var3);

    public abstract boolean requiresTxn();

    public abstract void flushBlobs(@Nullable LongHashMap<InputStream> var1, @Nullable LongHashMap<File> var2, @Nullable LongSet var3, @NotNull Transaction var4) throws Exception;

    public abstract long size();

    public abstract void clear();

    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStringContentCacheSize(int cacheSize) {
        Object object = this.stringContentCacheLock;
        synchronized (object) {
            this.stringContentCache = new SoftLongObjectCache(cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getStringContent(long blobHandle, @NotNull Transaction txn) throws IOException {
        String result;
        Object object = this.stringContentCacheLock;
        synchronized (object) {
            result = (String)this.stringContentCache.tryKey(blobHandle);
        }
        if (result == null) {
            InputStream content = this.getContent(blobHandle, txn);
            String string = result = content == null ? null : UTFUtil.readUTF((InputStream)content);
            if (result != null) {
                Object object2 = this.stringContentCacheLock;
                synchronized (object2) {
                    if (this.stringContentCache.getObject(blobHandle) == null) {
                        this.stringContentCache.cacheObject(blobHandle, (Object)result);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getStringContentCacheHitRate() {
        Object object = this.stringContentCacheLock;
        synchronized (object) {
            return this.stringContentCache.hitRate();
        }
    }

    public final ByteArrayOutputStream copyStream(@NotNull InputStream source, boolean closeSource) throws IOException {
        LightByteArrayOutputStream memCopy = new LightByteArrayOutputStream();
        IOUtil.copyStreams((InputStream)source, (OutputStream)memCopy, (ByteArraySpinAllocator)this.bufferAllocator);
        if (closeSource) {
            source.close();
        }
        return memCopy;
    }

    public final ByteArraySizedInputStream cloneStream(@NotNull InputStream source, boolean closeSource) throws IOException {
        ByteArrayOutputStream memCopy = this.copyStream(source, closeSource);
        return new ByteArraySizedInputStream(memCopy.toByteArray(), 0, memCopy.size());
    }
}

