/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

public enum StoreConfig {
    WITHOUT_DUPLICATES(0, "00000000"),
    WITH_DUPLICATES(1, "00000001"),
    WITHOUT_DUPLICATES_WITH_PREFIXING(2, "00000010"),
    WITH_DUPLICATES_WITH_PREFIXING(3, "00000011"),
    TEMPORARY_EMPTY(4, "00000100"),
    USE_EXISTING(5, "00001000");

    public final int id;
    public final boolean duplicates;
    public final boolean prefixing;
    public final boolean temporaryEmpty;
    public final boolean useExisting;

    private StoreConfig(int id, String mask) {
        this.id = id;
        int bits = Integer.parseInt(mask, 2);
        this.duplicates = (bits & 1) > 0;
        this.prefixing = (bits >> 1 & 1) > 0;
        this.temporaryEmpty = (bits >> 2 & 1) > 0;
        this.useExisting = (bits >> 3 & 1) > 0;
    }

    public String toString() {
        return "duplicates: " + this.duplicates + ", prefixing: " + this.prefixing + ", temporaryEmpty: " + this.temporaryEmpty + ", useExisting: " + this.useExisting;
    }
}

