/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.management;

import java.lang.ref.WeakReference;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.management.Statistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsItem
implements SharedTimer.ExpirablePeriodicTask {
    @NotNull
    private final WeakReference<Statistics> statisticsRef;
    private long total;
    private double mean;
    private long lastAdjustTime;
    private long lastAdjustedTotal;

    public StatisticsItem(@NotNull Statistics statistics) {
        this.statisticsRef = new WeakReference<Statistics>(statistics);
        this.total = 0L;
        this.mean = 0.0;
        this.lastAdjustTime = System.currentTimeMillis();
        this.lastAdjustedTotal = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotal() {
        WeakReference<Statistics> weakReference = this.statisticsRef;
        synchronized (weakReference) {
            return this.total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotal(long total) {
        WeakReference<Statistics> weakReference = this.statisticsRef;
        synchronized (weakReference) {
            this.total = total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMean() {
        WeakReference<Statistics> weakReference = this.statisticsRef;
        synchronized (weakReference) {
            return this.mean;
        }
    }

    public boolean isExpired() {
        return this.statisticsRef.get() == null;
    }

    public void run() {
        Long autoUpdatedTotal = this.getAutoUpdatedTotal();
        if (autoUpdatedTotal != null) {
            this.setTotal(autoUpdatedTotal);
        }
        this.adjustMean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTotal(long addend) {
        WeakReference<Statistics> weakReference = this.statisticsRef;
        synchronized (weakReference) {
            this.total += addend;
        }
    }

    public void incTotal() {
        this.addTotal(1L);
    }

    @Nullable
    protected Statistics getStatistics() {
        return (Statistics)this.statisticsRef.get();
    }

    @Nullable
    protected Long getAutoUpdatedTotal() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustMean() {
        if (this.total > this.lastAdjustedTotal) {
            WeakReference<Statistics> weakReference = this.statisticsRef;
            synchronized (weakReference) {
                if (this.total > this.lastAdjustedTotal) {
                    long currentTime = System.currentTimeMillis();
                    this.mean = (this.mean + (double)((this.total - this.lastAdjustedTotal) * 1000L) / (double)(currentTime - this.lastAdjustTime)) / 2.0;
                    this.lastAdjustTime = currentTime;
                    this.lastAdjustedTotal = this.total;
                }
            }
        }
    }
}

