/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import jetbrains.exodus.ByteIterable;
import org.jetbrains.annotations.NotNull;

public class ByteIterableUtil {
    private ByteIterableUtil() {
    }

    public static int compare(@NotNull ByteIterable key1, @NotNull ByteIterable key2) {
        return ByteIterableUtil.compare(key1.getBytesUnsafe(), key1.getLength(), key2.getBytesUnsafe(), key2.getLength());
    }

    public static int compare(@NotNull byte[] key1, int len1, @NotNull byte[] key2, int len2) {
        int min = Math.min(len1, len2);
        for (int i = 0; i < min; ++i) {
            byte b1 = key1[i];
            byte b2 = key2[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return len1 - len2;
    }

    public static int compare(@NotNull byte[] key1, int len1, int offset1, @NotNull byte[] key2, int len2) {
        int min = Math.min(len1 - offset1, len2);
        for (int i = 0; i < min; ++i) {
            byte b1 = key1[i + offset1];
            byte b2 = key2[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return len1 - offset1 - len2;
    }
}

