/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.OutputStream;
import java.util.Arrays;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.util.UTFUtil;
import org.jetbrains.annotations.NotNull;

public class LightOutputStream
extends OutputStream {
    private static final int DEFAULT_INIT_SIZE = 10;
    private int len;
    private byte[] buf;

    public LightOutputStream() {
        this(10);
    }

    public LightOutputStream(int initialSize) {
        this(new byte[initialSize]);
    }

    public LightOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.len = 0;
    }

    @NotNull
    public ArrayByteIterable asArrayByteIterable() {
        return new ArrayByteIterable(this.buf, this.len);
    }

    public void clear() {
        this.len = 0;
    }

    public int size() {
        return this.len;
    }

    @Override
    public void write(int b) {
        if (this.len >= this.buf.length) {
            this.ensureCapacity(this.len + 1);
        }
        this.buf[this.len++] = (byte)b;
    }

    @Override
    public void write(byte[] fromBuf) {
        this.ensureCapacity(this.len + fromBuf.length);
        System.arraycopy(fromBuf, 0, this.buf, this.len, fromBuf.length);
        this.len += fromBuf.length;
    }

    @Override
    public void write(byte[] fromBuf, int offset, int length) {
        this.ensureCapacity(this.len + length);
        System.arraycopy(fromBuf, offset, this.buf, this.len, length);
        this.len += length;
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public final void writeByte(int val) {
        this.write(val ^ 0x80);
    }

    public final void writeString(String value) {
        if (value == null) {
            this.write(255);
        } else if (value.length() > 0) {
            int utfLength = UTFUtil.getUtfByteLength((String)value);
            this.ensureCapacity(this.len + utfLength + 1);
            UTFUtil.utfCharsToBytes((String)value, (byte[])this.buf, (int)this.len);
            this.len += utfLength;
        }
        this.write(0);
    }

    public final void writeUnsignedShort(int val) {
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }

    public final void writeUnsignedInt(long val) {
        this.write((byte)(val >>> 24));
        this.write((byte)(val >>> 16));
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }

    public final void writeUnsignedLong(long val) {
        this.write((byte)(val >>> 56));
        this.write((byte)(val >>> 48));
        this.write((byte)(val >>> 40));
        this.write((byte)(val >>> 32));
        this.write((byte)(val >>> 24));
        this.write((byte)(val >>> 16));
        this.write((byte)(val >>> 8));
        this.write((byte)val);
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void ensureCapacity(int requiredCapacity) {
        int bufLen = this.buf.length;
        if (bufLen < requiredCapacity) {
            this.buf = Arrays.copyOf(this.buf, Math.max(requiredCapacity, bufLen < 50 ? bufLen << 2 : (bufLen < 1000 ? bufLen << 1 : (bufLen << 3) / 5)));
        }
    }
}

