/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0007\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0002H\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\n"}, d2={"extension", "", "Ljava/nio/file/Path;", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "combineSafe", "Ljava/io/File;", "relativePath", "dropLeadingTopDirs", "normalizeAndRelativize", "ktor-utils"})
public final class NioPathKt {
    @NotNull
    public static final String getExtension(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.substringAfterLast$default((String)((Object)$receiver.getFileName()).toString(), (String)".", null, (int)2, null);
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull Path $receiver, @NotNull Path relativePath) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw (Throwable)new InvalidPathException(((Object)relativePath).toString(), "Bad relative path " + relativePath);
        }
        boolean bl2 = bl = !normalized.isAbsolute();
        if (!bl) {
            boolean bl3 = false;
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File file = $receiver.resolve(normalized).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"resolve(normalized).toFile()");
        return file;
    }

    @KtorExperimentalAPI
    @NotNull
    public static final Path normalizeAndRelativize(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Path path = $receiver.getRoot();
        if (path == null || (path = path.relativize($receiver)) == null || (path = path.normalize()) == null || (path = NioPathKt.dropLeadingTopDirs(path)) == null) {
            Path path2 = $receiver.normalize();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"normalize()");
            path = NioPathKt.dropLeadingTopDirs(path2);
        }
        return path;
    }

    private static final Path dropLeadingTopDirs(@NotNull Path $receiver) {
        int startIndex;
        block4: {
            int n;
            Iterable $receiver$iv = $receiver;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Path it = (Path)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)((Object)it).toString(), (Object)"..") ^ true) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex == 0) {
            return $receiver;
        }
        Path path = $receiver.subpath(startIndex, $receiver.getNameCount());
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"subpath(startIndex, nameCount)");
        return path;
    }

    @KtorExperimentalAPI
    @NotNull
    public static final File combineSafe(@NotNull File $receiver, @NotNull Path relativePath) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw (Throwable)new InvalidPathException(((Object)relativePath).toString(), "Bad relative path " + relativePath);
        }
        boolean bl2 = bl = !normalized.isAbsolute();
        if (!bl) {
            boolean bl3 = false;
            String string = "Bad relative path " + relativePath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new File($receiver, ((Object)normalized).toString());
    }
}

