/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.analyzer;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.notifications.analyzer.AnalyzerJobFactory;
import jetbrains.youtrack.notifications.analyzer.BeansKt;
import jetbrains.youtrack.notifications.analyzer.EventMergeAdapter;
import jetbrains.youtrack.notifications.persistence.XdNotificationManagement;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="eventMergeAnalyzer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/notifications/analyzer/EventMergeAnalyzer;", "", "()V", "digestJobFactory", "Ljetbrains/youtrack/notifications/analyzer/AnalyzerJobFactory;", "granularJobFactory", "issueCreatedCategory", "Ljetbrains/youtrack/api/events/EventCategory;", "tagsCategory", "analyze", "", "merge", "Ljetbrains/youtrack/api/events/EventMerge;", "durable", "youtrack-custom-notifications"})
public final class EventMergeAnalyzer {
    @Autowired
    private AnalyzerJobFactory granularJobFactory;
    @Autowired
    private AnalyzerJobFactory digestJobFactory;
    @Autowired
    private EventCategory issueCreatedCategory;
    @Autowired
    private EventCategory tagsCategory;

    public final boolean analyze(@NotNull EventMerge merge, boolean durable) {
        AnalyzerJobFactory analyzerJobFactory;
        Intrinsics.checkParameterIsNotNull((Object)merge, (String)"merge");
        XdIssue issue = (XdIssue)XdExtensionsKt.toXd((Entity)merge.getIssue());
        EventMergeAdapter mergeAdapter = new EventMergeAdapter(merge);
        EventCategory eventCategory = this.tagsCategory;
        if (eventCategory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tagsCategory");
        }
        Event tagEvent = mergeAdapter.firstNonSilentEvent(eventCategory);
        if (mergeAdapter.isSilent() && tagEvent == null) {
            return false;
        }
        boolean deprecated = ((XdNotificationManagement)XdNotificationManagement.Companion.get()).getUseDeprecatedNotificationScheme();
        if (deprecated) {
            analyzerJobFactory = this.granularJobFactory;
            if (analyzerJobFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"granularJobFactory");
            }
        } else {
            analyzerJobFactory = this.digestJobFactory;
            if (analyzerJobFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"digestJobFactory");
            }
        }
        AnalyzerJobFactory factory = analyzerJobFactory;
        if (!mergeAdapter.isSilent()) {
            Job issueChangeAnalyzerJob = factory.createIssueJob(mergeAdapter, durable);
            BeansKt.getNotifyingAnalyzerJobProcessor().queue(issueChangeAnalyzerJob);
        }
        EventCategory eventCategory2 = this.issueCreatedCategory;
        if (eventCategory2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"issueCreatedCategory");
        }
        if (mergeAdapter.hasEvent(eventCategory2)) {
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Entity author = merge.getAuthor();
            Iterable iterable = $receiver$iv = issue.getTags().getEntityIterable();
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Entity tag = (Entity)element$iv$iv;
                boolean bl = false;
                if (!(!EntityOperations.isRemoved((Entity)tag))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Entity tag = (Entity)element$iv;
                boolean bl2 = false;
                Job addedTagOnCreationAnalyzerJob = factory.createTagJob(merge, tag, author, false);
                BeansKt.getNotifyingAnalyzerJobProcessor().queue(addedTagOnCreationAnalyzerJob);
            }
        }
        Event event2 = tagEvent;
        if (event2 != null) {
            Object tag;
            Entity tag2;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Event event3;
            Event event4 = event3 = event2;
            boolean bl = false;
            Entity author = merge.getAuthor();
            Iterable iterable = event4.getAddedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"event.addedLinks");
            Iterable bl2 = $receiver$iv = iterable;
            Collection destination$iv$iv = new ArrayList();
            Iterator $i$f$forEach = $receiver$iv$iv.iterator();
            while ($i$f$forEach.hasNext()) {
                Object element$iv$iv = $i$f$forEach.next();
                tag2 = (Entity)element$iv$iv;
                boolean bl3 = false;
                if (!(!EntityOperations.isRemoved((Entity)tag2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                tag = (Entity)element$iv;
                boolean bl4 = false;
                Entity entity = tag;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"tag");
                Job addedTagAnalyzerJob = factory.createTagJob(merge, entity, author, false);
                BeansKt.getNotifyingAnalyzerJobProcessor().queue(addedTagAnalyzerJob);
            }
            Iterable iterable2 = event4.getRemovedLinks();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"event.removedLinks");
            $receiver$iv = iterable2;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            tag = $receiver$iv$iv.iterator();
            while (tag.hasNext()) {
                Object element$iv$iv = tag.next();
                tag2 = (Entity)element$iv$iv;
                boolean bl5 = false;
                if (!(!EntityOperations.isRemoved((Entity)tag2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                tag = (Entity)element$iv;
                boolean bl6 = false;
                Object object = tag;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tag");
                Job removedTagAnalyzerJob = factory.createTagJob(merge, (Entity)object, author, true);
                BeansKt.getNotifyingAnalyzerJobProcessor().queue(removedTagAnalyzerJob);
            }
        }
        return true;
    }
}

