/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.charisma.service.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventCategory;
import jetbrains.youtrack.api.events.EventNotificationAdapter;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.notifications.analyzer.NotificationAnalysisMutable;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/notifications/analyzer/MentionUserAnalyzer;", "", "reasonIssueId", "", "tasks", "Ljetbrains/youtrack/notifications/analyzer/NotificationAnalysisMutable;", "(Ljava/lang/String;Ljetbrains/youtrack/notifications/analyzer/NotificationAnalysisMutable;)V", "analyze", "", "adapters", "", "Ljetbrains/youtrack/api/events/EventNotificationAdapter;", "findMentions", "event", "Ljetbrains/youtrack/api/events/Event;", "isAccessible", "", "entity", "Ljetbrains/exodus/entitystore/Entity;", "user", "Ljetbrains/youtrack/persistent/XdUser;", "tryToAppendMentionReasons", "targetEntity", "mention", "findUsersByLogin", "", "Companion", "youtrack-custom-notifications"})
public final class MentionUserAnalyzer {
    private final String reasonIssueId;
    private final NotificationAnalysisMutable tasks;
    private static final char USER_LOGIN_MARK = '@';
    private static final char DEFAULT_LOGIN_SEPARATOR = ' ';
    private static final String DEFAULT_VALID_LOGIN_PREFIX = "_";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void analyze(@NotNull Iterable<? extends EventNotificationAdapter> adapters) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(adapters, (String)"adapters");
        String name$iv = "commentTextCategory";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.events.EventCategory");
        }
        EventCategory commentTextCategory = (EventCategory)object;
        String name$iv2 = "descriptionCategory";
        boolean $i$f$getBean22 = false;
        Object object2 = ServiceLocator.getBean((String)name$iv2);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.events.EventCategory");
        }
        EventCategory descriptionTextCategory = (EventCategory)object2;
        Iterable $i$f$getBean22 = $receiver$iv = adapters;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            EventCategory eventCategory;
            EventNotificationAdapter it = (EventNotificationAdapter)element$iv$iv;
            boolean bl = false;
            EventCategory it2 = eventCategory = it.getAdaptedEventCategory();
            boolean bl2 = false;
            boolean bl3 = it2 == commentTextCategory || it2 == descriptionTextCategory;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Event event2;
            EventNotificationAdapter it = (EventNotificationAdapter)element$iv;
            boolean bl = false;
            Event event3 = event2 = it.getEvent();
            boolean bl4 = false;
            Event event4 = event3;
            Intrinsics.checkExpressionValueIsNotNull((Object)event4, (String)"event");
            if (event4.getOldPropertyValue() != null) continue;
            this.findMentions(event3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findMentions(Event event2) {
        CharSequence charSequence;
        Entity entity = null;
        String text = (String)((Object)event2.getNewPropertyValue());
        if (text == null || (charSequence = (CharSequence)text).length() == 0) {
            return;
        }
        text = text + ' ';
        int length = text.length();
        int currentMentionMark = -1;
        char c = '\u0000';
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            c = text.charAt((int)i);
            if (currentMentionMark != -1) {
                if (c == ' ' || !LoginUtils.isValidLogin((String)(DEFAULT_VALID_LOGIN_PREFIX + c))) {
                    int mentionBegin = currentMentionMark + 1;
                    if (i > mentionBegin) {
                        String string;
                        if (entity == null) {
                            entity = event2.getTarget();
                        }
                        String string2 = text;
                        Entity entity2 = entity;
                        MentionUserAnalyzer mentionUserAnalyzer = this;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(mentionBegin, (int)i), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        mentionUserAnalyzer.tryToAppendMentionReasons(entity2, string);
                    }
                    currentMentionMark = -1;
                }
            } else if (c == '@') {
                currentMentionMark = i;
            }
            ++i;
        }
    }

    private final void tryToAppendMentionReasons(Entity targetEntity, String mention) {
        List<XdUser> users2 = this.findUsersByLogin(mention);
        if (users2.isEmpty()) {
            Companion.getLogger().info((Function0)new Function0<String>(targetEntity, mention){
                final /* synthetic */ Entity $targetEntity;
                final /* synthetic */ String $mention;

                @NotNull
                public final String invoke() {
                    return "Could not find any user login in mention [" + this.$targetEntity.getId() + ':' + this.$mention + ']';
                }
                {
                    this.$targetEntity = entity;
                    this.$mention = string;
                    super(0);
                }
            });
        } else {
            Iterable $receiver$iv = users2;
            for (Object element$iv : $receiver$iv) {
                boolean mentionDisabled;
                XdUser it = (XdUser)element$iv;
                boolean bl = false;
                boolean bl2 = mentionDisabled = !BeansKt.getUserProfileService().getNotificationsProfile(it).isMentionNotificationsEnabled();
                if (mentionDisabled) {
                    Companion.getLogger().info((Function0)new Function0<String>(it, this, targetEntity, mention){
                        final /* synthetic */ XdUser $it;
                        final /* synthetic */ MentionUserAnalyzer this$0;
                        final /* synthetic */ Entity $targetEntity$inlined;
                        final /* synthetic */ String $mention$inlined;
                        {
                            this.$it = xdUser;
                            this.this$0 = mentionUserAnalyzer;
                            this.$targetEntity$inlined = entity;
                            this.$mention$inlined = string;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Skip mention of user " + this.$it.getLogin() + " in [" + this.$targetEntity$inlined.getId() + ':' + this.$mention$inlined + "] - disabled @Mention";
                        }
                    });
                    continue;
                }
                if (this.isAccessible(targetEntity, it)) {
                    this.tasks.addMentionReason(it, targetEntity, this.reasonIssueId);
                    continue;
                }
                Companion.getLogger().info((Function0)new Function0<String>(it, this, targetEntity, mention){
                    final /* synthetic */ XdUser $it;
                    final /* synthetic */ MentionUserAnalyzer this$0;
                    final /* synthetic */ Entity $targetEntity$inlined;
                    final /* synthetic */ String $mention$inlined;
                    {
                        this.$it = xdUser;
                        this.this$0 = mentionUserAnalyzer;
                        this.$targetEntity$inlined = entity;
                        this.$mention$inlined = string;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Skip mention of user " + this.$it.getLogin() + " in [" + this.$targetEntity$inlined.getId() + ':' + this.$mention$inlined + "] - no access";
                    }
                });
            }
        }
    }

    private final List<XdUser> findUsersByLogin(@NotNull String $receiver) {
        XdUser user;
        List result = new ArrayList();
        String remainder = $receiver;
        Entity entity = BeansKt.getUserFilterService().searchGreedyByLogin(remainder);
        Object object = user = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        while (user != null) {
            Object object2;
            result.add(user);
            CharSequence charSequence = remainder;
            int n = user.getLogin().length();
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = remainder;
            if (charSequence.length() > 0 && remainder.charAt(0) == '@') {
                charSequence = remainder;
                n = 1;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                remainder = string2;
                charSequence = remainder;
                if (charSequence.length() > 0) {
                    Entity entity2;
                    Entity entity3 = entity2 = BeansKt.getUserFilterService().searchGreedyByLogin(remainder);
                    object2 = entity3 != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity3) : null;
                } else {
                    object2 = null;
                }
            } else {
                object2 = null;
            }
            user = object2;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAccessible(Entity entity, XdUser user) {
        XdEntity xdEntity;
        XdEntity xdEntity2 = xdEntity = XdExtensionsKt.toXd((Entity)entity);
        boolean bl = false;
        if (xdEntity2 instanceof XdIssue) {
            if (((XdIssue)xdEntity2).isAccessible(Operation.READ, user)) return true;
        }
        if (!(xdEntity2 instanceof XdIssueComment)) return false;
        XdEntity xdEntity3 = xdEntity2;
        XdIssueComment it = (XdIssueComment)xdEntity3;
        boolean bl2 = false;
        if (!it.isAccessible(Operation.READ, user)) return false;
        if (!it.getIssue().isAccessible(Operation.READ, user)) return false;
        return true;
    }

    public MentionUserAnalyzer(@NotNull String reasonIssueId, @NotNull NotificationAnalysisMutable tasks2) {
        Intrinsics.checkParameterIsNotNull((Object)reasonIssueId, (String)"reasonIssueId");
        Intrinsics.checkParameterIsNotNull((Object)tasks2, (String)"tasks");
        this.reasonIssueId = reasonIssueId;
        this.tasks = tasks2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/notifications/analyzer/MentionUserAnalyzer$Companion;", "Lmu/KLogging;", "()V", "DEFAULT_LOGIN_SEPARATOR", "", "DEFAULT_VALID_LOGIN_PREFIX", "", "USER_LOGIN_MARK", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

