/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.controller;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.util.Set;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.notifications.Localization;
import jetbrains.youtrack.notifications.controller.BeansKt;
import jetbrains.youtrack.notifications.controller.UserDefinedTemplateManager;
import jetbrains.youtrack.notifications.controller.UserDefinedTemplateManager$findCustomNotificationTemplate$;
import jetbrains.youtrack.notifications.controller.UserDefinedTemplateManager$resetAllTemplatesToDefault$;
import jetbrains.youtrack.notifications.controller.UserDefinedTemplateManager$saveTemplateContent$;
import jetbrains.youtrack.notifications.controller.loaders.CascadeTemplateLoader;
import jetbrains.youtrack.notifications.persistence.XdCustomNotificationTemplate;
import jetbrains.youtrack.notifications.persistence.XdNotificationTemplate;
import jetbrains.youtrack.notifications.persistence.XdProjectNotificationTemplate;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="userTemplateManager")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016J \u0010\u0017\u001a\u00020\u00182\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/notifications/controller/UserDefinedTemplateManager;", "", "()V", "deleteCustomNotificationTemplate", "", "name", "", "project", "Ljetbrains/youtrack/persistent/XdProject;", "findCustomNotificationTemplate", "Ljetbrains/youtrack/notifications/persistence/XdNotificationTemplate;", "getTemplateContent", "p", "getTemplateContentOtherwiseCreateStub", "getTemplateContentStub", "cause", "getTemplateDescription", "log", "content", "resetAllTemplatesToDefault", "", "locked", "", "saveTemplateContent", "", "newContent", "Companion", "youtrack-custom-notifications"})
public class UserDefinedTemplateManager {
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    private static final String EMPTY_STRING = "";
    private static final Logger TEMPLATE_LOG;
    public static final Companion Companion;

    @NotNull
    public final Iterable<String> resetAllTemplatesToDefault(@NotNull Set<String> locked) {
        Intrinsics.checkParameterIsNotNull(locked, (String)"locked");
        boolean $i$f$transactional = false;
        return SequencesKt.asIterable((Sequence)((Sequence)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Sequence<? extends String>>(this, locked){
            final /* synthetic */ UserDefinedTemplateManager this$0;
            final /* synthetic */ Set $locked$inlined;
            {
                this.this$0 = userDefinedTemplateManager;
                this.$locked$inlined = set;
                super(1);
            }

            public final Sequence<? extends String> invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdCustomNotificationTemplate.Companion.all()), (Function1)((Function1)new Function1<XdCustomNotificationTemplate, Boolean>(this){
                    final /* synthetic */ resetAllTemplatesToDefault$$inlined$transactional$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final boolean invoke(@NotNull XdCustomNotificationTemplate it) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        return !it.isRemoved() && !this.this$0.$locked$inlined.contains(it.getFreemarkerId());
                    }
                })), (Function1)((Function1)new Function1<XdCustomNotificationTemplate, String>(this){
                    final /* synthetic */ resetAllTemplatesToDefault$$inlined$transactional$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke(@NotNull XdCustomNotificationTemplate template2) {
                        void var2_2;
                        Intrinsics.checkParameterIsNotNull((Object)((Object)template2), (String)"template");
                        String name = template2.getFreemarkerId();
                        UserDefinedTemplateManager.access$log(this.this$0.this$0, name, template2.getContent());
                        this.this$0.this$0.deleteCustomNotificationTemplate(name, null);
                        return var2_2;
                    }
                }));
            }
        }), (int)7, null)));
    }

    private final void log(String name, String content2) {
        TEMPLATE_LOG.info("--------------------Reset to default-------------------------------");
        TEMPLATE_LOG.info("Notification template " + name + ", deleted user defined content:");
        TEMPLATE_LOG.info("-------------------------------------------------------------------");
        TEMPLATE_LOG.info(content2);
    }

    public final boolean saveTemplateContent(@Nullable XdProject p, @NotNull String name, @NotNull String newContent) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)newContent, (String)"newContent");
        boolean $i$f$transactional = false;
        return (Boolean)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Boolean>(this, name, p, newContent){
            final /* synthetic */ UserDefinedTemplateManager this$0;
            final /* synthetic */ String $name$inlined;
            final /* synthetic */ XdProject $p$inlined;
            final /* synthetic */ String $newContent$inlined;
            {
                this.this$0 = userDefinedTemplateManager;
                this.$name$inlined = string;
                this.$p$inlined = xdProject;
                this.$newContent$inlined = string2;
                super(1);
            }

            public final Boolean invoke(@NotNull TransientStoreSession it) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl2 = false;
                String oldContent = null;
                try {
                    oldContent = UserDefinedTemplateManager.access$getTemplateContent(this.this$0, this.$name$inlined, this.$p$inlined);
                }
                catch (IOException ioe) {
                    UserDefinedTemplateManager.Companion.getLogger().error((Throwable)ioe, (Function0)new Function0<String>(this){
                        final /* synthetic */ saveTemplateContent$$inlined$transactional$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Could not load " + this.this$0.$name$inlined + " template content";
                        }
                    });
                    oldContent = null;
                }
                if (Intrinsics.areEqual((Object)this.$newContent$inlined, (Object)oldContent)) {
                    bl = false;
                } else {
                    boolean $i$f$transactional = false;
                    TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Object>(this){
                        final /* synthetic */ saveTemplateContent$$inlined$transactional$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final Object invoke(@NotNull TransientStoreSession it) {
                            Object object;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            boolean bl = false;
                            XdNotificationTemplate custom = this.this$0.this$0.findCustomNotificationTemplate(this.this$0.$name$inlined, this.this$0.$p$inlined);
                            if (custom == null) {
                                object = this.this$0.$p$inlined == null ? XdCustomNotificationTemplate.Companion.new$default(XdCustomNotificationTemplate.Companion, this.this$0.$name$inlined, this.this$0.$newContent$inlined, null, 4, null) : XdProjectNotificationTemplate.Companion.new$default(XdProjectNotificationTemplate.Companion, this.this$0.$p$inlined, this.this$0.$name$inlined, this.this$0.$newContent$inlined, null, 8, null);
                            } else {
                                custom.setContent(this.this$0.$newContent$inlined);
                                object = Unit.INSTANCE;
                            }
                            return object;
                        }
                    }), (int)7, null);
                    bl = true;
                }
                return bl;
            }
        }), (int)7, null);
    }

    @Nullable
    public final XdNotificationTemplate findCustomNotificationTemplate(@NotNull String name, @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        boolean $i$f$transactional = false;
        return (XdNotificationTemplate)((Object)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, XdNotificationTemplate>(project, name){
            final /* synthetic */ XdProject $project$inlined;
            final /* synthetic */ String $name$inlined;
            {
                this.$project$inlined = xdProject;
                this.$name$inlined = string;
                super(1);
            }

            public final XdNotificationTemplate invoke(@NotNull TransientStoreSession it) {
                XdNotificationTemplate xdNotificationTemplate;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                XdNotificationTemplate custom = null;
                custom = this.$project$inlined == null ? (XdNotificationTemplate)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdCustomNotificationTemplate.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdCustomNotificationTemplate, XdSearchingNode>(this){
                    final /* synthetic */ findCustomNotificationTemplate$$inlined$transactional$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdCustomNotificationTemplate it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        return $receiver.eq((Comparable)((Object)it.getFreemarkerId()), (Comparable)((Object)this.this$0.$name$inlined));
                    }
                }))) : (XdNotificationTemplate)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdProjectNotificationTemplate.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdProjectNotificationTemplate, XdSearchingNode>(this){
                    final /* synthetic */ findCustomNotificationTemplate$$inlined$transactional$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdProjectNotificationTemplate it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        return $receiver.eq((Comparable)((Object)it.getFreemarkerId()), (Comparable)((Object)this.this$0.$name$inlined)).and($receiver.eq((XdEntity)it.getProject(), (XdEntity)this.this$0.$project$inlined));
                    }
                })));
                XdNotificationTemplate xdNotificationTemplate2 = custom;
                if (xdNotificationTemplate2 != null) {
                    XdNotificationTemplate xdNotificationTemplate3;
                    XdNotificationTemplate it2 = xdNotificationTemplate3 = xdNotificationTemplate2;
                    boolean bl2 = false;
                    xdNotificationTemplate = it2.isRemoved() ? null : it2;
                } else {
                    xdNotificationTemplate = null;
                }
                return xdNotificationTemplate;
            }
        }), (int)7, null));
    }

    public final void deleteCustomNotificationTemplate(@NotNull String name, @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        boolean $i$f$transactional = false;
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, name, project){
            final /* synthetic */ UserDefinedTemplateManager this$0;
            final /* synthetic */ String $name$inlined;
            final /* synthetic */ XdProject $project$inlined;
            {
                this.this$0 = userDefinedTemplateManager;
                this.$name$inlined = string;
                this.$project$inlined = xdProject;
                super(1);
            }

            public final Unit invoke(@NotNull TransientStoreSession it) {
                Unit unit;
                XdNotificationTemplate custom;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                XdNotificationTemplate xdNotificationTemplate = custom = this.this$0.findCustomNotificationTemplate(this.$name$inlined, this.$project$inlined);
                if (xdNotificationTemplate != null) {
                    xdNotificationTemplate.delete();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        }), (int)7, null);
    }

    @Nullable
    public final String getTemplateContentOtherwiseCreateStub(@NotNull String name, @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            return this.getTemplateContent(name, project);
        }
        catch (IOException ioe) {
            String string;
            Companion.getLogger().error((Throwable)ioe, (Function0)getTemplateContentOtherwiseCreateStub.1.INSTANCE);
            XdNotificationTemplate template2 = this.findCustomNotificationTemplate(name, project);
            if (template2 != null) {
                string = template2.getContent();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                string = this.getTemplateContentStub(ioe.getMessage(), name);
            }
            return string;
        }
    }

    @NotNull
    public final String getTemplateDescription(@NotNull String name, @Nullable XdProject p) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Configuration cfg = BeansKt.getNotificationConfigurationProvider().getConfiguration(p);
            String description = (String)cfg.getTemplate(name).getCustomAttribute(DESCRIPTION_ATTRIBUTE_NAME);
            String string = description;
            if (string == null) {
                string = EMPTY_STRING;
            }
            return string;
        }
        catch (IOException ioe) {
            return EMPTY_STRING;
        }
    }

    private final String getTemplateContent(String name, XdProject p) throws IOException {
        Configuration cfg = BeansKt.getNotificationConfigurationProvider().getConfiguration(p);
        Template template2 = cfg.getTemplate(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)template2, (String)"cfg.getTemplate(name)");
        String encoding = template2.getEncoding();
        TemplateLoader templateLoader = cfg.getTemplateLoader();
        if (templateLoader == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.controller.loaders.CascadeTemplateLoader");
        }
        CascadeTemplateLoader cascadeTemplateLoader = (CascadeTemplateLoader)templateLoader;
        String string = encoding;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"encoding");
        return cascadeTemplateLoader.loadContent(name, string);
    }

    private final String getTemplateContentStub(String cause, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)Localization.INSTANCE.getCannotLoadDefaultNotificationTemplate().invoke((Object)name));
        sb.append("\n");
        sb.append(cause);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    static {
        Companion = new Companion(null);
        TEMPLATE_LOG = LoggerFactory.getLogger((String)"templates");
    }

    public static final /* synthetic */ void access$log(UserDefinedTemplateManager $this, String name, String content2) {
        $this.log(name, content2);
    }

    public static final /* synthetic */ String access$getTemplateContent(UserDefinedTemplateManager $this, String name, XdProject p) {
        return $this.getTemplateContent(name, p);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/notifications/controller/UserDefinedTemplateManager$Companion;", "Lmu/KLogging;", "()V", "DESCRIPTION_ATTRIBUTE_NAME", "", "EMPTY_STRING", "TEMPLATE_LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getTEMPLATE_LOG", "()Lorg/slf4j/Logger;", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        public final Logger getTEMPLATE_LOG() {
            return TEMPLATE_LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

