/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.main;

import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.notifications.AbstractNotificationCase;
import jetbrains.youtrack.api.notifications.NotificationComponentType;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationGroup;
import jetbrains.youtrack.api.notifications.NotificationTemplateDescriptor;
import jetbrains.youtrack.api.notifications.YouTrackNotificationHeader;
import jetbrains.youtrack.notifications.accessData.IssueSnapshotAdapter;
import jetbrains.youtrack.notifications.main.DigestTagNotificationCase$WhenMappings;
import jetbrains.youtrack.notifications.main.EventSearchUtilKt;
import jetbrains.youtrack.notifications.main.TestDataUtilsKt;
import jetbrains.youtrack.notifications.plugin.NotificationsXdModelPluginKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="digestTagNotificationCase")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/notifications/main/DigestTagNotificationCase;", "Ljetbrains/youtrack/api/notifications/AbstractNotificationCase;", "()V", "auxiliaryTemplateFooter", "Ljetbrains/youtrack/api/notifications/NotificationTemplateDescriptor;", "auxiliaryTemplateIssueHeader", "auxiliaryTemplateReasonJabber", "availableVariables", "", "", "getAvailableVariables", "()Ljava/util/Set;", "header", "Ljetbrains/youtrack/api/notifications/YouTrackNotificationHeader;", "getHeader", "()Ljetbrains/youtrack/api/notifications/YouTrackNotificationHeader;", "parent", "Ljetbrains/youtrack/api/notifications/NotificationGroup;", "getParent", "()Ljetbrains/youtrack/api/notifications/NotificationGroup;", "extendWithTestData", "", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "ctxIssue", "Ljetbrains/exodus/entitystore/Entity;", "recipient", "requiresTemplates", "", "type", "Ljetbrains/youtrack/api/notifications/NotificationComponentType;", "retrieveDataId", "youtrack-custom-notifications"})
public final class DigestTagNotificationCase
extends AbstractNotificationCase {
    @Autowired
    @Qualifier(value="auxiliaryTemplateIssueHeader")
    private NotificationTemplateDescriptor auxiliaryTemplateIssueHeader;
    @Autowired
    @Qualifier(value="auxiliaryTemplateFooter")
    private NotificationTemplateDescriptor auxiliaryTemplateFooter;
    @Autowired
    @Qualifier(value="auxiliaryTemplateReasonJabber")
    private NotificationTemplateDescriptor auxiliaryTemplateReasonJabber;

    @NotNull
    public List<NotificationTemplateDescriptor> requiresTemplates(@NotNull NotificationComponentType type) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        switch (DigestTagNotificationCase$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object[] objectArray = new NotificationTemplateDescriptor[2];
                NotificationTemplateDescriptor notificationTemplateDescriptor = this.auxiliaryTemplateIssueHeader;
                if (notificationTemplateDescriptor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateIssueHeader");
                }
                objectArray[0] = notificationTemplateDescriptor;
                NotificationTemplateDescriptor notificationTemplateDescriptor2 = this.auxiliaryTemplateFooter;
                if (notificationTemplateDescriptor2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateFooter");
                }
                objectArray[1] = notificationTemplateDescriptor2;
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 2: {
                NotificationTemplateDescriptor notificationTemplateDescriptor = this.auxiliaryTemplateReasonJabber;
                if (notificationTemplateDescriptor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateReasonJabber");
                }
                list = CollectionsKt.listOf((Object)notificationTemplateDescriptor);
                break;
            }
            default: {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    @Nullable
    public NotificationGroup getParent() {
        String name$iv = "digestSchemeGroup";
        boolean $i$f$getBean = false;
        return (NotificationGroup)ServiceLocator.getBean((String)name$iv);
    }

    @NotNull
    public YouTrackNotificationHeader getHeader() {
        return YouTrackNotificationHeader.ISSUE_TAGGED;
    }

    public void extendWithTestData(@NotNull NotificationData data, @NotNull Entity ctxIssue, @NotNull Entity recipient) {
        NotificationData notificationData;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)ctxIssue, (String)"ctxIssue");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        XdIssue issue = (XdIssue)XdExtensionsKt.toXd((Entity)ctxIssue);
        XdUser to = (XdUser)XdExtensionsKt.toXd((Entity)recipient);
        Event event2 = EventSearchUtilKt.findLastEvent(issue, "tagsCategory");
        if (event2 == null) {
            throw (Throwable)new IllegalArgumentException(BeansKt.getLocalizer().localizedMsg("NotificationTemplates.test.issue_has_no_tags_change", new Object[]{issue.getIdReadable()}));
        }
        Event tagsEvent = event2;
        boolean untag = !QueryOperations.isEmpty((Iterable)tagsEvent.getRemovedLinks());
        Entity tag = QueryOperations.getFirst((Iterable)(untag ? tagsEvent.getRemovedLinks() : tagsEvent.getAddedLinks()));
        IssueSnapshotAdapter issueAdapter = new IssueSnapshotAdapter(issue);
        NotificationData $receiver = notificationData = data;
        boolean bl = false;
        $receiver.set("from", (Object)issue.getReporter());
        $receiver.set("to", (Object)to);
        $receiver.set("issue", (Object)issueAdapter);
        $receiver.set("reason", (Object)TestDataUtilsKt.createTagTestReason(to, issueAdapter));
        $receiver.set("init_notification", (Object)(!XdQueryKt.contains((XdQuery)((XdQuery)NotificationsXdModelPluginKt.getNotifiedUsers(issue)), (XdEntity)((XdEntity)to)) ? 1 : 0));
        $receiver.set("tag", (Object)tag);
        $receiver.set("untag", (Object)untag);
    }

    @NotNull
    public Set<String> getAvailableVariables() {
        return SetsKt.setOf((Object[])new String[]{"from", "to", "issue", "tag", "untag", "reason"});
    }

    @Nullable
    public String retrieveDataId(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object object = data.get("tag");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.Entity");
        }
        return ((Entity)object).toIdString();
    }

    public DigestTagNotificationCase() {
        super("issue_tag", "NotificationTemplates.Issue_tag_title", "NotificationTemplates.Issue_tag_description");
    }
}

