/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.plugin;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.notifications.NotificationHeader;
import jetbrains.youtrack.api.notifications.YouTrackNotificationHeader;
import jetbrains.youtrack.api.statistics.BeansKt;
import jetbrains.youtrack.api.statistics.StatisticsFeatureDescription;
import jetbrains.youtrack.api.workflow.annotations.ApiDoc;
import jetbrains.youtrack.api.workflow.annotations.ApiJsAcceptsJson;
import jetbrains.youtrack.api.workflow.annotations.ApiJsDocIgnore;
import jetbrains.youtrack.api.workflow.annotations.ApiJsOptional;
import jetbrains.youtrack.api.workflow.annotations.ApiKtIgnore;
import jetbrains.youtrack.api.workflow.annotations.ApiMethod;
import jetbrains.youtrack.api.workflow.annotations.ApiScope;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0007\u001a$\u0010\f\u001a\u00020\r*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\bH\u0007\u001a6\u0010\f\u001a\u00020\r*\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\u00012\b\b\u0001\u0010\u000f\u001a\u00020\u00012\b\b\u0001\u0010\u0010\u001a\u00020\b2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u001a \u0010\u0013\u001a\u00020\r*\u00020\u00142\b\b\u0001\u0010\u000e\u001a\u00020\u00012\b\b\u0001\u0010\u000f\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0015\u001a\u00020\r*\u00020\n2\b\b\u0001\u0010\u0016\u001a\u00020\u0001H\u0007\u001a \u0010\u0017\u001a\u00020\r*\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\u00012\b\b\u0001\u0010\u000f\u001a\u00020\u0001H\u0007\u001a<\u0010\u0017\u001a\u00020\r*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u0010\u001a\u00020\b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"STATISTICS_CATEGORY", "", "STATISTICS_EMAIL_TO_GROUP", "STATISTICS_EMAIL_TO_USER", "STATISTICS_JABBER_TO_USER", "USER_EMAIL_PREFIX", "USER_JABBER_PREFIX", "shouldNotify", "", "to", "Ljetbrains/youtrack/persistent/XdUser;", "from", "notify", "", "subject", "body", "ignoreNotifyOnOwnChangesSetting", "project", "Ljetbrains/youtrack/persistent/XdProject;", "notifyAllUsers", "Ljetbrains/youtrack/persistent/XdUserGroup;", "sendJabber", "message", "sendMail", "currentUser", "Ljetbrains/exodus/entitystore/Entity;", "youtrack-custom-notifications"})
public final class ExtensionsKt {
    private static final String USER_EMAIL_PREFIX = "n";
    private static final String USER_JABBER_PREFIX = "j";
    private static final String STATISTICS_CATEGORY = "workflow";
    private static final String STATISTICS_JABBER_TO_USER = "jabberNotificationToUser";
    private static final String STATISTICS_EMAIL_TO_USER = "emailNotificationToUser";
    private static final String STATISTICS_EMAIL_TO_GROUP = "groupNotification";

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends an email notification to all of the users who are members of the group.\n@example\nissue.oldValue('permittedGroup').notifyAllUsers('Visibility has been changed',\n  'The visibility group for the issue ' + issue.getId() +\n  ' has been changed to ' + permittedGroup.name);")
    public static final void notifyAllUsers(@NotNull XdUserGroup $receiver, @ApiDoc(value="The subject line of the email notification.") @NotNull String subject, @ApiDoc(value="The message text of the email notification.") @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription(STATISTICS_CATEGORY, STATISTICS_EMAIL_TO_GROUP));
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)$receiver.getUsers()));
        for (Object element$iv : $receiver$iv) {
            XdUser it = (XdUser)element$iv;
            boolean bl = false;
            ExtensionsKt.notify(it, subject, body);
        }
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiKtIgnore
    @ApiJsDocIgnore
    public static final void notify(@NotNull XdUser $receiver, @NotNull String subject, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.notify($receiver, subject, body, false);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiKtIgnore
    @ApiJsDocIgnore
    public static final void notify(@NotNull XdUser $receiver, @NotNull String subject, @NotNull String body, boolean ignoreNotifyOnOwnChangesSetting) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.notify($receiver, subject, body, ignoreNotifyOnOwnChangesSetting, null);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends an email notification to the email address that is set in the user profile.")
    @ApiJsAcceptsJson
    public static final void notify(@NotNull XdUser $receiver, @ApiDoc(value="The subject line of the email notification.") @NotNull String subject, @ApiDoc(value="The message text of the email notification.") @NotNull String body, @ApiDoc(value="If `false`, the message is not sent when changes are performed on behalf of the current user. Otherwise, the message is sent anyway.") @ApiJsOptional boolean ignoreNotifyOnOwnChangesSetting, @ApiDoc(value="When set, the email address that is used as the 'From' address for the specified project is used to send the message.") @ApiJsOptional @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.sendMail($receiver, subject, body, jetbrains.charisma.persistent.BeansKt.getLoggedInUserOrNull(), ignoreNotifyOnOwnChangesSetting, project);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends an email notification to the email address that is set in the user profile. An alias for notify(subject, body, true).")
    public static final void sendMail(@NotNull XdUser $receiver, @ApiDoc(value="The subject line of the email notification.") @NotNull String subject, @ApiDoc(value="The message text of the email notification.") @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ExtensionsKt.sendMail$default($receiver, subject, body, null, false, null, 24, null);
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Sends a notification message over Jabber. Similar to the `notify`\nmethod, the message won't be sent on own changes and corresponding flag unchecked.")
    public static final void sendJabber(@NotNull XdUser $receiver, @ApiDoc(value="The message text for the Jabber notification.") @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription(STATISTICS_CATEGORY, STATISTICS_JABBER_TO_USER));
        if (ExtensionsKt.shouldNotify$default($receiver, null, 2, null)) {
            jetbrains.youtrack.notifications.sending.BeansKt.getNotificationProvider().instantNotify($receiver.getEntity(), USER_JABBER_PREFIX, null, null, null, null, null, message);
        }
    }

    private static final void sendMail(@NotNull XdUser $receiver, String subject, String body, Entity currentUser, boolean ignoreNotifyOnOwnChangesSetting, XdProject project) {
        XdUser from;
        BeansKt.getStatisticsService().incForInstance(new StatisticsFeatureDescription(STATISTICS_CATEGORY, STATISTICS_EMAIL_TO_USER));
        XdUser to = $receiver;
        Entity entity = currentUser;
        Object object = from = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        if (ignoreNotifyOnOwnChangesSetting || ExtensionsKt.shouldNotify(to, from)) {
            XdUser xdUser = from;
            XdProject xdProject = project;
            jetbrains.youtrack.notifications.sending.BeansKt.getNotificationProvider().instantNotify(to.getEntity(), USER_EMAIL_PREFIX, (Entity)(xdUser != null ? xdUser.getEntity() : null), (Entity)(xdProject != null ? xdProject.getEntity() : null), (NotificationHeader)YouTrackNotificationHeader.SIMPLE, subject, body, null);
        }
    }

    static /* synthetic */ void sendMail$default(XdUser xdUser, String string, String string2, Entity entity, boolean bl, XdProject xdProject, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            xdProject = null;
        }
        ExtensionsKt.sendMail(xdUser, string, string2, entity, bl, xdProject);
    }

    private static final boolean shouldNotify(XdUser to, XdUser from) {
        return to.getBanned() ? false : (Intrinsics.areEqual((Object)to, (Object)from) ? jetbrains.charisma.service.BeansKt.getUserProfileService().getNotificationsProfile(to).isNotifyOnOwnChanges() : true);
    }

    static /* synthetic */ boolean shouldNotify$default(XdUser xdUser, XdUser xdUser2, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser2 = null;
        }
        return ExtensionsKt.shouldNotify(xdUser, xdUser2);
    }
}

