/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.notifications.MessageIdUtils;
import jetbrains.youtrack.notifications.sending.BeansKt;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="messageIdUtils")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/notifications/sending/MessageIdUtilsImpl;", "Ljetbrains/youtrack/api/notifications/MessageIdUtils;", "()V", "generateIssueId", "", "generateRootId", "nonHistoricalIssue", "Ljetbrains/exodus/entitystore/Entity;", "generateSystemId", "getHostName", "isYoutrackGeneratedMessageId", "", "id", "youtrack-custom-notifications"})
public class MessageIdUtilsImpl
implements MessageIdUtils {
    private final String getHostName() {
        String string = BeansKt.getMailSender().getHost();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public String generateSystemId() {
        return "<System" + System.currentTimeMillis() + '@' + this.getHostName() + '>';
    }

    @NotNull
    public String generateIssueId() {
        return "<Issue" + System.currentTimeMillis() + '@' + this.getHostName() + '>';
    }

    @NotNull
    public String generateRootId(@NotNull Entity nonHistoricalIssue) {
        Intrinsics.checkParameterIsNotNull((Object)nonHistoricalIssue, (String)"nonHistoricalIssue");
        return '<' + ((XdIssue)XdExtensionsKt.toXd((Entity)nonHistoricalIssue)).getIdReadable() + '@' + this.getHostName() + '>';
    }

    public boolean isYoutrackGeneratedMessageId(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Pattern p = Pattern.compile("((System|Issue)(\\d+)|(\\d+)-(\\d+)|(\\w+)-(\\d+))@" + this.getHostName() + ".*");
        Matcher m = p.matcher(id);
        return m.matches();
    }
}

