/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.notifications.NotificationCase;
import jetbrains.youtrack.api.notifications.NotificationComponentType;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.notifications.analyzer.CompositeReason;
import jetbrains.youtrack.notifications.gaprest.BeansKt;
import jetbrains.youtrack.notifications.sending.NotificationChannel;
import jetbrains.youtrack.notifications.sending.NotificationJob;
import jetbrains.youtrack.notifications.sending.PersistentNotificationDataSerializer;
import jetbrains.youtrack.notifications.sending.PersistentNotificationJob;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/notifications/sending/PersistNotificationsChannel;", "Ljetbrains/youtrack/notifications/sending/NotificationChannel;", "()V", "isEnabled", "", "()Z", "createNotificationJob", "Ljetbrains/youtrack/notifications/sending/NotificationJob;", "case", "Ljetbrains/youtrack/api/notifications/NotificationCase;", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "sender", "Ljetbrains/youtrack/persistent/XdUser;", "recipient", "reason", "Ljetbrains/youtrack/notifications/analyzer/CompositeReason;", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "Ljetbrains/exodus/entitystore/Entity;", "Companion", "youtrack-custom-notifications"})
public final class PersistNotificationsChannel
implements NotificationChannel {
    @NotNull
    public static final String JOB_SUFFIX = "PR";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isEnabled() {
        return jetbrains.charisma.persistent.BeansKt.getXdNotificationsConfig().getEnablePersistentNotifications();
    }

    @Override
    public boolean isEnabled(@NotNull Entity recipient) {
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        return true;
    }

    @Override
    @NotNull
    public NotificationJob createNotificationJob(@NotNull NotificationCase notificationCase, @NotNull NotificationData data, @Nullable XdUser sender, @NotNull XdUser recipient, @Nullable CompositeReason reason, @Nullable XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)notificationCase, (String)"case");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        String jobId = this.composeNotificationJobId(notificationCase, data, sender, recipient, issue);
        return new PersistentNotificationJob(issue, data, notificationCase, recipient, jobId, sender, reason, jobId + ":PR", recipient, sender, reason){
            final /* synthetic */ XdIssue $issue;
            final /* synthetic */ NotificationData $data;
            final /* synthetic */ NotificationCase $case;
            final /* synthetic */ XdUser $recipient;
            final /* synthetic */ String $jobId;
            final /* synthetic */ XdUser $sender;
            final /* synthetic */ CompositeReason $reason;

            @Nullable
            protected Entity getContextProject() {
                XdIssue xdIssue = this.$issue;
                return xdIssue != null && (xdIssue = xdIssue.getProject()) != null ? xdIssue.getEntity() : null;
            }

            @NotNull
            public String getDecompressedMetadata() {
                return PersistentNotificationDataSerializer.INSTANCE.serialize(this.$data);
            }

            @Nullable
            public String render(@NotNull NotificationComponentType type) {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                Entity entity = this.getContextProject();
                return BeansKt.getTemplateRenderer().render(this.$data.getRootMap(), this.$case.getTemplateId(type), (XdProject)(entity != null ? (XdProject)XdExtensionsKt.toXd((Entity)entity) : null));
            }

            protected boolean sendNotification() {
                if (!this.$case.isPersistable()) {
                    this.logWarning("notification case is not supported");
                    return false;
                }
                XdIssue xdIssue = this.$issue;
                if (xdIssue != null) {
                    XdIssue xdIssue2;
                    XdIssue it = xdIssue2 = xdIssue;
                    boolean bl = false;
                    if (it.isRemoved()) {
                        this.logWarning("issue was deleted");
                        return false;
                    }
                    if (!it.isAccessible(Operation.READ, this.$recipient)) {
                        return false;
                    }
                }
                return super.sendNotification();
            }
            {
                this.$issue = $captured_local_variable$0;
                this.$data = $captured_local_variable$1;
                this.$case = $captured_local_variable$2;
                this.$recipient = $captured_local_variable$3;
                this.$jobId = $captured_local_variable$4;
                this.$sender = $captured_local_variable$5;
                this.$reason = $captured_local_variable$6;
                super($super_call_param$7, $super_call_param$8, $super_call_param$9, $super_call_param$10);
            }
        };
    }

    @Override
    @NotNull
    public String composeNotificationJobId(@NotNull NotificationCase notificationCase, @NotNull NotificationData data, @Nullable XdUser from, @NotNull XdUser to, @Nullable XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)notificationCase, (String)"case");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        return NotificationChannel.DefaultImpls.composeNotificationJobId(this, notificationCase, data, from, to, issue);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/notifications/sending/PersistNotificationsChannel$Companion;", "Lmu/KLogging;", "()V", "JOB_SUFFIX", "", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

