/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.provider.filter;

import java.util.Collections;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import jetbrains.mps.internal.collections.runtime.LinkedListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;

public abstract class CorsContainerResponseFilter
implements ContainerResponseFilter {
    private static final String ACCESS_CONTROL_HEADER = "Access-Control-Allow-Origin";
    private static final String ORIGIN_HEADER_NAME = "Origin";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private static String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private static String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        String requestOrigin;
        if (response != null && this.isAllowedOrigin(requestOrigin = request.getHeaderString(ORIGIN_HEADER_NAME))) {
            response.getHeaders().put((Object)ACCESS_CONTROL_HEADER, Collections.unmodifiableList(LinkedListSequence.fromListAndArray((LinkedList)new LinkedList(), (Object[])new Object[]{requestOrigin})));
            response.getHeaders().put((Object)ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, Collections.unmodifiableList(LinkedListSequence.fromListAndArray((LinkedList)new LinkedList(), (Object[])new Object[]{true})));
            String requestedHeadersToAllow = request.getHeaderString(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
            if (requestedHeadersToAllow != null && requestedHeadersToAllow.length() > 0) {
                response.getHeaders().put((Object)ACCESS_CONTROL_ALLOW_HEADERS_HEADER, Collections.unmodifiableList(LinkedListSequence.fromListAndArray((LinkedList)new LinkedList(), (Object[])new Object[]{requestedHeadersToAllow})));
            }
        }
    }

    protected abstract Iterable<String> getAllowedOrigins();

    protected boolean isAllowedOrigin(String requestOrigin) {
        if (requestOrigin == null) {
            return false;
        }
        Iterable<String> allowedOrigins = this.getAllowedOrigins();
        if (allowedOrigins == null) {
            return true;
        }
        return Sequence.fromIterable(allowedOrigins).contains((Object)requestOrigin);
    }
}

