/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.io.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.coroutines.io.internal.RingBufferCapacity$Companion$AvailableForRead$1;
import kotlinx.coroutines.io.internal.RingBufferCapacity$Companion$AvailableForWrite$1;
import kotlinx.coroutines.io.internal.RingBufferCapacity$Companion$PendingToFlush$1;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/coroutines/io/internal/RingBufferCapacity;", "", "totalCapacity", "", "(I)V", "availableForRead", "availableForWrite", "pendingToFlush", "completeRead", "", "n", "completeReadOverflow", "", "pending", "remaining", "update", "completeWrite", "flush", "", "forceLockForRelease", "isEmpty", "isFull", "resetForRead", "resetForWrite", "tryLockForRelease", "tryReadAtMost", "tryReadExact", "tryWriteAtLeast", "tryWriteAtMost", "tryWriteExact", "Companion", "kotlinx-coroutines-io"})
public final class RingBufferCapacity {
    @JvmField
    public volatile int availableForRead;
    @JvmField
    public volatile int availableForWrite;
    @JvmField
    public volatile int pendingToFlush;
    private final int totalCapacity;
    private static final AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForRead;
    private static final AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForWrite;
    private static final AtomicIntegerFieldUpdater<RingBufferCapacity> PendingToFlush;
    public static final Companion Companion;

    public final void resetForWrite() {
        this.availableForRead = 0;
        this.availableForWrite = this.totalCapacity;
        this.pendingToFlush = 0;
    }

    public final void resetForRead() {
        this.availableForRead = this.totalCapacity;
        this.availableForWrite = 0;
        this.pendingToFlush = 0;
    }

    public final boolean tryReadExact(int n) {
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForRead2 = AvailableForRead;
        do {
            if ((remaining = this.availableForRead) >= n) continue;
            return false;
        } while (!AvailableForRead2.compareAndSet(this, remaining, remaining - n));
        return true;
    }

    public final int tryReadAtMost(int n) {
        int delta;
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForRead2 = AvailableForRead;
        do {
            if ((delta = Math.min(n, remaining = this.availableForRead)) != 0) continue;
            return 0;
        } while (!AvailableForRead2.compareAndSet(this, remaining, remaining - delta));
        return delta;
    }

    public final int tryWriteAtLeast(int n) {
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForWrite2 = AvailableForWrite;
        do {
            if ((remaining = this.availableForWrite) >= n) continue;
            return 0;
        } while (!AvailableForWrite2.compareAndSet(this, remaining, 0));
        return remaining;
    }

    public final boolean tryWriteExact(int n) {
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForWrite2 = AvailableForWrite;
        do {
            if ((remaining = this.availableForWrite) >= n) continue;
            return false;
        } while (!AvailableForWrite2.compareAndSet(this, remaining, remaining - n));
        return true;
    }

    public final int tryWriteAtMost(int n) {
        int delta;
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForWrite2 = AvailableForWrite;
        do {
            if ((delta = Math.min(n, remaining = this.availableForWrite)) != 0) continue;
            return 0;
        } while (!AvailableForWrite2.compareAndSet(this, remaining, remaining - delta));
        return delta;
    }

    public final void completeRead(int n) {
        int update;
        int remaining;
        int totalCapacity = this.totalCapacity;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForWrite2 = AvailableForWrite;
        do {
            if ((update = (remaining = this.availableForWrite) + n) <= totalCapacity) continue;
            Void void_ = this.completeReadOverflow(remaining, update, n);
            throw null;
        } while (!AvailableForWrite2.compareAndSet(this, remaining, update));
    }

    private final Void completeReadOverflow(int remaining, int update, int n) {
        throw (Throwable)new IllegalArgumentException("Completed read overflow: " + remaining + " + " + n + " = " + update + " > " + this.totalCapacity);
    }

    public final void completeWrite(int n) {
        int update;
        int pending;
        int totalCapacity = this.totalCapacity;
        AtomicIntegerFieldUpdater<RingBufferCapacity> PendingToFlush2 = PendingToFlush;
        do {
            if ((update = (pending = this.pendingToFlush) + n) <= totalCapacity) continue;
            Void void_ = this.completeReadOverflow(pending, n);
            throw null;
        } while (!PendingToFlush2.compareAndSet(this, pending, update));
    }

    private final Void completeReadOverflow(int pending, int n) {
        throw (Throwable)new IllegalArgumentException("Complete write overflow: " + pending + " + " + n + " > " + this.totalCapacity);
    }

    public final boolean flush() {
        int update;
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForRead2 = AvailableForRead;
        int pending = PendingToFlush.getAndSet(this, 0);
        while ((remaining = this.availableForRead) != (update = remaining + pending) && !AvailableForRead2.compareAndSet(this, remaining, update)) {
        }
        return update > 0;
    }

    public final boolean tryLockForRelease() {
        int remaining;
        AtomicIntegerFieldUpdater<RingBufferCapacity> AvailableForWrite2 = AvailableForWrite;
        do {
            remaining = this.availableForWrite;
            if (this.pendingToFlush <= 0 && this.availableForRead <= 0 && remaining == this.totalCapacity) continue;
            return false;
        } while (!AvailableForWrite2.compareAndSet(this, remaining, 0));
        return true;
    }

    public final void forceLockForRelease() {
        AvailableForWrite.getAndSet(this, 0);
    }

    public final boolean isEmpty() {
        return this.availableForWrite == this.totalCapacity;
    }

    public final boolean isFull() {
        return this.availableForWrite == 0;
    }

    public RingBufferCapacity(int totalCapacity) {
        this.availableForWrite = this.totalCapacity = totalCapacity;
    }

    static {
        Companion = new Companion(null);
        KProperty1 p$iv = (KProperty1)RingBufferCapacity$Companion$AvailableForRead$1.INSTANCE;
        boolean $i$f$intUpdater = false;
        AtomicIntegerFieldUpdater<RingBufferCapacity> atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(RingBufferCapacity.class, p$iv.getName());
        Intrinsics.checkExpressionValueIsNotNull(atomicIntegerFieldUpdater, (String)"AtomicIntegerFieldUpdate\u2026wner::class.java, p.name)");
        AvailableForRead = atomicIntegerFieldUpdater;
        p$iv = (KProperty1)RingBufferCapacity$Companion$AvailableForWrite$1.INSTANCE;
        $i$f$intUpdater = false;
        AtomicIntegerFieldUpdater<RingBufferCapacity> atomicIntegerFieldUpdater2 = AtomicIntegerFieldUpdater.newUpdater(RingBufferCapacity.class, p$iv.getName());
        Intrinsics.checkExpressionValueIsNotNull(atomicIntegerFieldUpdater2, (String)"AtomicIntegerFieldUpdate\u2026wner::class.java, p.name)");
        AvailableForWrite = atomicIntegerFieldUpdater2;
        p$iv = (KProperty1)RingBufferCapacity$Companion$PendingToFlush$1.INSTANCE;
        $i$f$intUpdater = false;
        AtomicIntegerFieldUpdater<RingBufferCapacity> atomicIntegerFieldUpdater3 = AtomicIntegerFieldUpdater.newUpdater(RingBufferCapacity.class, p$iv.getName());
        Intrinsics.checkExpressionValueIsNotNull(atomicIntegerFieldUpdater3, (String)"AtomicIntegerFieldUpdate\u2026wner::class.java, p.name)");
        PendingToFlush = atomicIntegerFieldUpdater3;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkotlinx/coroutines/io/internal/RingBufferCapacity$Companion;", "", "()V", "AvailableForRead", "Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;", "Lkotlinx/coroutines/io/internal/RingBufferCapacity;", "AvailableForWrite", "PendingToFlush", "kotlinx-coroutines-io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

