/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.internal;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.internal.PartitionMetadataProvider;
import software.amazon.awssdk.regions.internal.model.Partitions;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public final class RegionMetadataLoader {
    private static volatile PartitionMetadataProvider provider;
    private static final String PARTITIONS_RESOURCE_PATH = "software/amazon/awssdk/regions/internal/region/endpoints.json";
    private static final String PARTITIONS_OVERRIDE_RESOURCE_PATH = "software/amazon/awssdk/regions/partitions/override/endpoints.json";
    private static final ClassLoader CLASS_LOADER;

    private RegionMetadataLoader() {
    }

    public static RegionMetadata getRegionMetadata(Region region) {
        if (provider == null) {
            RegionMetadataLoader.build();
        }
        return provider.getRegionMetadata(region);
    }

    public static ServiceMetadata getServiceMetadata(String serviceEndpointPrefix) {
        if (provider == null) {
            RegionMetadataLoader.build();
        }
        return provider.getServiceMetadata(serviceEndpointPrefix);
    }

    protected static void build() {
        InputStream stream = CLASS_LOADER.getResourceAsStream(PARTITIONS_OVERRIDE_RESOURCE_PATH);
        if (stream != null) {
            provider = new PartitionMetadataProvider(RegionMetadataLoader.loadPartitionFromStream(stream, PARTITIONS_OVERRIDE_RESOURCE_PATH).getPartitions());
        } else {
            stream = CLASS_LOADER.getResourceAsStream(PARTITIONS_RESOURCE_PATH);
            if (stream == null) {
                throw SdkClientException.builder().message("Unable to load partition metadata from software/amazon/awssdk/regions/internal/region/endpoints.json").build();
            }
            provider = new PartitionMetadataProvider(RegionMetadataLoader.loadPartitionFromStream(stream, PARTITIONS_RESOURCE_PATH).getPartitions());
        }
    }

    private static Partitions loadPartitionFromStream(InputStream stream, String location) {
        try {
            Partitions partitions = (Partitions)JSON.std.with(new JSON.Feature[]{JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY}).with(new JSON.Feature[]{JSON.Feature.USE_IS_GETTERS}).beanFrom(Partitions.class, (Object)stream);
            return partitions;
        }
        catch (IOException | RuntimeException e) {
            throw SdkClientException.builder().message("Error while loading partitions file from " + location).cause((Throwable)e).build();
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)stream, null);
        }
    }

    static {
        CLASS_LOADER = RegionMetadataLoader.class.getClassLoader();
    }
}

