/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.launcher.conf.provider;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.configs.AppJavaInfo;
import com.jetbrains.launcher.configs.JvmOptionsProvider;
import com.jetbrains.launcher.plugins.PluginContext;
import com.jetbrains.launcher.util.AppRuntimeUtil;
import com.jetbrains.launcher.util.JavaUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleJvmOptionsProviderImpl
implements JvmOptionsProvider {
    static final Map<String, String> versionMap = new HashMap<String, String>();

    @NotNull
    public List<String> getJvmOptions(@NotNull PluginContext context, @NotNull AppJavaInfo appJavaInfo, @NotNull AppFiles appFiles) {
        ArrayList<String> jvmOptions = new ArrayList<String>();
        String javaVersion = appJavaInfo.getVersion().getVersion();
        String alpnBootVersion = "1.8.0_181".equals(javaVersion) ? this.resolveAlpnBootJarForJava8u181(appJavaInfo.getVersion()) : (versionMap.containsKey(javaVersion) ? versionMap.get(javaVersion) : (javaVersion.startsWith("1.8.") ? BundleJvmOptionsProviderImpl.getAlpnBootForLatestJre8() : null));
        if (alpnBootVersion != null) {
            File libFolder = appFiles.getAppLibFolder();
            jvmOptions.add("-Xbootclasspath/p:" + libFolder.getAbsolutePath() + "/alpn/1.8/" + this.buildJarName(alpnBootVersion));
        }
        if (!javaVersion.startsWith("1.")) {
            jvmOptions.add(AppRuntimeUtil.extraLibDirsToJvmOption((String[])new String[]{"/alpn/1.9/"}));
        }
        return jvmOptions;
    }

    @Nullable
    private String resolveAlpnBootJarForJava8u181(JavaUtil.JavaVersion javaVersionInfo) {
        String alpnBootVersion;
        String javaVersion = javaVersionInfo.getVersion();
        String javaRuntimeVersion = javaVersionInfo.getRuntimeVersion();
        if (javaRuntimeVersion != null && javaRuntimeVersion.contains("ubuntu")) {
            if (javaRuntimeVersion.equals("1.8.0_181-8u181-b13-0ubuntu0.16.04.1-b13")) {
                alpnBootVersion = versionMap.get(javaVersion);
            } else {
                this.reportIncompatibleJava8(javaRuntimeVersion);
                alpnBootVersion = null;
            }
        } else if (javaRuntimeVersion != null && javaRuntimeVersion.contains("~deb")) {
            if (javaRuntimeVersion.equals("1.8.0_181-8u181-b13-1~deb9u1-b13")) {
                alpnBootVersion = versionMap.get(javaVersion);
            } else {
                this.reportIncompatibleJava8(javaRuntimeVersion);
                alpnBootVersion = null;
            }
        } else {
            alpnBootVersion = versionMap.get(javaVersion);
        }
        return alpnBootVersion;
    }

    private void reportIncompatibleJava8(String javaRuntimeVersion) {
        System.out.println(String.format("WARN: Incompatible java package %s is detected. Skip adding alpn-boot jar to java bootstrap classpath...", javaRuntimeVersion));
        System.out.println("WARN: Built-in TLS support won't work. Please use latest available Oracle jre 8 package in order to start with built-in TLS support...");
    }

    static String getAlpnBootForLatestJre8() {
        return versionMap.get(Collections.max(versionMap.keySet(), new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                return BundleJvmOptionsProviderImpl.parseJavaUpdateNumber(o1) - BundleJvmOptionsProviderImpl.parseJavaUpdateNumber(o2);
            }
        }));
    }

    static int parseJavaUpdateNumber(@NotNull String o1) {
        return Integer.parseInt(o1.replaceFirst("1.8.0_?", "0"));
    }

    private String buildJarName(String version) {
        return "alpn-boot-" + version + ".jar";
    }

    static {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(BundleJvmOptionsProviderImpl.class.getResourceAsStream("/version_mapping.properties")));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] versions = line.split("=");
                versionMap.put(versions[0], versions[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

