/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.config;

import com.jetbrains.bundle.api.internal.auth.AuthService;
import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtensionProvider;
import com.jetbrains.bundle.api.internal.awc.ext.model.KeyStoreSettings;
import com.jetbrains.bundle.awc.rest.AuthInterceptor;
import com.jetbrains.bundle.awc.service.HubManagerService;
import com.jetbrains.bundle.awc.service.MigrationServicesProvider;
import com.jetbrains.bundle.awc.service.impl.HubManagerServiceImp;
import com.jetbrains.bundle.awc.service.impl.MigrationServicesProviderImpl;
import com.jetbrains.bundle.awc.service.impl.actions.HubActionExecutor;
import com.jetbrains.bundle.awc.service.impl.actions.HubMigrationHolder;
import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.validation.AdditionalKeystore;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidator;
import com.jetbrains.bundle.util.auth.Authenticator;
import com.jetbrains.bundle.util.auth.impl.AuthenticatorCountingAttemptsImpl;
import com.jetbrains.service.util.UrlUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.WebContentInterceptor;

@Configuration
@EnableWebMvc
public class AppConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        WebContentInterceptor interceptor = new WebContentInterceptor();
        interceptor.setCacheSeconds(0);
        interceptor.setCacheControl(CacheControl.noStore());
        registry.addInterceptor((HandlerInterceptor)interceptor);
        AuthInterceptor authInterceptor = new AuthInterceptor(this.getAuthenticator());
        registry.addInterceptor((HandlerInterceptor)authInterceptor);
    }

    @Bean
    @NotNull
    public AdminConsoleExtension getAdminConsoleExtension() {
        AdminConsoleExtension adminConsoleExtension = AdminConsoleExtensionProvider.getAdminConsoleExtension();
        adminConsoleExtension.init();
        return adminConsoleExtension;
    }

    @Bean
    @NotNull
    public HubManagerService getHubToHubMigrationService() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new HubManagerServiceImp(this.getMigrationServicesProvider());
    }

    @Bean
    @NotNull
    AdditionalKeystore getAdditionalKeystore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStoreSettings keyStoreSettings = this.getAdminConsoleExtension().getKeyStoreSettings();
        Path additionalKeystorePath = keyStoreSettings.getKeyStoreFile().getAbsoluteFile().toPath();
        String additionalKeystorePassword = keyStoreSettings.getKeyStorePassword();
        return new AdditionalKeystore(additionalKeystorePath, additionalKeystorePassword);
    }

    @Bean
    @NotNull
    public HubClientProvider getHubClientProvider() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        AdditionalKeystore additionalKeystore = this.getAdditionalKeystore();
        return new HubClientProvider(additionalKeystore.getKeyStore(), additionalKeystore.getKeyStorePassword());
    }

    @Bean
    @NotNull
    public HubMigrationHolder getHubMigrationHolder() {
        return new HubMigrationHolder(this.getAdminConsoleExtension());
    }

    @Bean
    public HubActionExecutor getHubImportActionExecutor() {
        return new HubActionExecutor();
    }

    @Bean
    public MigrationServicesProvider getMigrationServicesProvider() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new MigrationServicesProviderImpl(this.getAdminConsoleExtension(), this.getHubClientProvider(), this.getHubMigrationHolder(), this.getHubImportActionExecutor(), this.getHubUrlValidator());
    }

    @Bean
    public Authenticator getAuthenticator() {
        return new AuthenticatorCountingAttemptsImpl((AuthService)this.getAdminConsoleExtension());
    }

    @Bean
    public HubUrlValidator getHubUrlValidator() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return new HubUrlValidator(this.getHubClientProvider(), UrlUtil.isSecuredUrl((String)this.getAdminConsoleExtension().getProductState().getDefaultServiceUrl()), this.getAdminConsoleExtension().getProductState().getProductName());
    }
}

