/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.exceptions;

public enum ErrorMessage {
    UNEXPECTED(0, "Unexpected error occurred: %s"),
    HUB_URL_IS_INVALID(1, "Hub URL %s is invalid"),
    PARAMETER_MISSING(2, "Parameter %s is required"),
    PARAMETER_MISSING_FOR_ACTION(3, "Parameter %s is required for action %s"),
    COULD_NOT_CREATE_SERVICE_IN_EXTERNAL_HUB_ANONYMOUSLY(5, "Can not create service anonymously. User credentials should be provided for basic authorization"),
    OBJECT_NOT_FOUND_EXCEPTION(6, "%s not found."),
    ALREADY_IN_USE(7, "Already in use by %s"),
    MIGRATION_FAILED(8, "Migration has failed with status [%s]"),
    ACCESS_TOKEN_IS_REQUIRED_FOR_NOT_VERIFIED_SERVICE(9, "Service %s is not verified in Hub [%s]. User access token is required"),
    ADMIN_CONSOLE_AUTH_EXCEPTION(10, "Invalid token"),
    EXTERNAL_HUB_AUTHORIZATION_BY_TOKEN_FAILED(11, "Not authorized access by token"),
    EXTERNAL_HUB_AUTHORIZATION_BY_SERVICE_FAILED(12, "Not authorized access by service credentials"),
    EXTERNAL_HUB_DOES_NOT_ALLOW_MIGRATION(13, "The Hub service at address %s does not allow data migration, it does not have its own license and is most likely the built-in Hub service for an existing product. Please enter the URL of your external Hub service."),
    CANNOT_SWITCH_TO_EXTERNAL_HUB_SERVICES_ARE_ABSENT(14, "External Hub [%s] does not have product services"),
    CANNOT_SWITCH_TO_EXTERNAL_HUB_SERVICES_HAVE_WRONG_SECRETS(15, "Some product services [%s] are registered in External Hub [%s] but have another secrets"),
    RELINK_TO_EXTERNAL_HUB_AFTER_IMPORT_IS_NOT_ALLOWED(16, "Product can not be relinked to External Hub after DB import"),
    TARGET_HUB_DOES_NOT_HAVE_SERVICES_REGISTERED_BY_PRODUCT(17, "%s"),
    TOO_MANY_FAILED_AUTHENTICATION_ATTEMPTS(18, "Too many failed authentication attempts was performed"),
    HUB_HOME_URL_IS_INVALID(19, "Hub home URL %s is invalid or not available"),
    EXTERNAL_HUB_ERROR(20, "Error occurred while communicating with Hub %s"),
    EXTERNAL_HUB_VERSION_IS_LESSER_THEN_VERSION_OF_BUILTIN_HUB(21, "External Hub (%s) is older than built-in one (%s)");

    private int code;
    private String message;

    private ErrorMessage(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getMessage(String ... params) {
        return String.format(this.message, params);
    }

    public int getCode() {
        return this.code;
    }
}

