/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.awc.exceptions;

import com.intellij.hub.core.Error;
import com.jetbrains.bundle.awc.exceptions.AdminConsoleException;
import com.jetbrains.bundle.awc.exceptions.ErrorMessage;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import jetbrains.jetpass.client.resource.ErrorHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportForbiddenException
extends AdminConsoleException {
    @NotNull
    private final Error error;

    public ImportForbiddenException(@NotNull String hubUrl, @NotNull WebApplicationException cause) {
        super(ErrorMessage.EXTERNAL_HUB_ERROR, (Throwable)cause, hubUrl);
        final Error originalError = ErrorHelper.INSTANCE.readError(cause);
        this.error = new Error(){

            @NotNull
            public String getError() {
                return originalError.getError();
            }

            public int getStatusCode() {
                return originalError.getStatusCode();
            }

            @NotNull
            public String getMessage() {
                return originalError.getMessage() + " (most probably user currently logged in to external Hub doesn't have 'Low Level Administration' permission)";
            }

            @Nullable
            public String getDeveloperMessage() {
                return originalError.getDeveloperMessage();
            }

            @Nullable
            public URI getURI() {
                return originalError.getURI();
            }

            @Nullable
            public String getField() {
                return originalError.getField();
            }
        };
    }

    @NotNull
    public Error getError() {
        return this.error;
    }
}

